@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.AthenaFunctions.getNamedQueryPlain
import com.pulumi.aws.athena.kotlin.inputs.GetNamedQueryPlainArgs
import com.pulumi.aws.athena.kotlin.inputs.GetNamedQueryPlainArgsBuilder
import com.pulumi.aws.athena.kotlin.outputs.GetNamedQueryResult
import com.pulumi.aws.athena.kotlin.outputs.GetNamedQueryResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AthenaFunctions {
    /**
     * Provides an Athena Named Query data source.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.athena.AthenaFunctions;
     * import com.pulumi.aws.athena.inputs.GetNamedQueryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AthenaFunctions.getNamedQuery(GetNamedQueryArgs.builder()
     *             .name("athenaQueryName")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNamedQuery.
     * @return A collection of values returned by getNamedQuery.
     */
    public suspend fun getNamedQuery(argument: GetNamedQueryPlainArgs): GetNamedQueryResult =
        toKotlin(getNamedQueryPlain(argument.toJava()).await())

    /**
     * @see [getNamedQuery].
     * @param name The plain language name for the query. Maximum length of 128.
     * @param workgroup The workgroup to which the query belongs. Defaults to `primary`.
     * @return A collection of values returned by getNamedQuery.
     */
    public suspend fun getNamedQuery(name: String, workgroup: String? = null): GetNamedQueryResult {
        val argument = GetNamedQueryPlainArgs(
            name = name,
            workgroup = workgroup,
        )
        return toKotlin(getNamedQueryPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamedQuery].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;athena&#46;kotlin&#46;inputs&#46;GetNamedQueryPlainArgs].
     * @return A collection of values returned by getNamedQuery.
     */
    public suspend fun getNamedQuery(argument: suspend GetNamedQueryPlainArgsBuilder.() -> Unit):
        GetNamedQueryResult {
        val builder = GetNamedQueryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getNamedQueryPlain(builtArgument.toJava()).await())
    }
}
