@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.DatabaseArgs.builder
import com.pulumi.aws.athena.kotlin.inputs.DatabaseAclConfigurationArgs
import com.pulumi.aws.athena.kotlin.inputs.DatabaseAclConfigurationArgsBuilder
import com.pulumi.aws.athena.kotlin.inputs.DatabaseEncryptionConfigurationArgs
import com.pulumi.aws.athena.kotlin.inputs.DatabaseEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Athena database.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleDatabase = new Database("exampleDatabase", DatabaseArgs.builder()
 *             .name("database_name")
 *             .bucket(exampleBucketV2.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Databases using their name. For example:
 * ```sh
 *  $ pulumi import aws:athena/database:Database example example
 * ```
 *  Certain resource arguments, like `encryption_configuration` and `bucket`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property aclConfiguration That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
 * @property bucket Name of S3 bucket to save the results of the query execution.
 * @property comment Description of the database.
 * @property encryptionConfiguration Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
 * @property expectedBucketOwner AWS account ID that you expect to be the owner of the Amazon S3 bucket.
 * @property forceDestroy Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
 * @property name Name of the database to create.
 * @property properties Key-value map of custom metadata properties for the database definition.
 */
public data class DatabaseArgs(
    public val aclConfiguration: Output<DatabaseAclConfigurationArgs>? = null,
    public val bucket: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val encryptionConfiguration: Output<DatabaseEncryptionConfigurationArgs>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.DatabaseArgs> {
    override fun toJava(): com.pulumi.aws.athena.DatabaseArgs =
        com.pulumi.aws.athena.DatabaseArgs.builder()
            .aclConfiguration(aclConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DatabaseArgs].
 */
@PulumiTagMarker
public class DatabaseArgsBuilder internal constructor() {
    private var aclConfiguration: Output<DatabaseAclConfigurationArgs>? = null

    private var bucket: Output<String>? = null

    private var comment: Output<String>? = null

    private var encryptionConfiguration: Output<DatabaseEncryptionConfigurationArgs>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("ufgknvbtfregbqwq")
    public suspend fun aclConfiguration(`value`: Output<DatabaseAclConfigurationArgs>) {
        this.aclConfiguration = value
    }

    /**
     * @param value Name of S3 bucket to save the results of the query execution.
     */
    @JvmName("tsldgevtpxfefnlb")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("dakguyktunhkthvh")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("omakcevcbrlfvoou")
    public suspend fun encryptionConfiguration(`value`: Output<DatabaseEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("ilgadudujpxtojtk")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
     */
    @JvmName("djgywtjuoheoplok")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the database to create.
     */
    @JvmName("rydaudionrndawwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("srdocvvnmtgxuipv")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("fqmnxeimgovvxjgq")
    public suspend fun aclConfiguration(`value`: DatabaseAclConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclConfiguration = mapped
    }

    /**
     * @param argument That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("xhlphpdnilauaexn")
    public suspend
    fun aclConfiguration(argument: suspend DatabaseAclConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseAclConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aclConfiguration = mapped
    }

    /**
     * @param value Name of S3 bucket to save the results of the query execution.
     */
    @JvmName("ardnjyayoiexfydc")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("ynoaxkpgtguvutwr")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("dprquafofvaksdrt")
    public suspend fun encryptionConfiguration(`value`: DatabaseEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("qdbtjgmvmgyshhjs")
    public suspend
    fun encryptionConfiguration(argument: suspend DatabaseEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("tvwqnuqllafpycji")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
     */
    @JvmName("tnnlixulfaamwgvf")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the database to create.
     */
    @JvmName("pauigwxjheqvutvt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("kyhloeaomebqgmhk")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("rfhngkypqvkasfmw")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): DatabaseArgs = DatabaseArgs(
        aclConfiguration = aclConfiguration,
        bucket = bucket,
        comment = comment,
        encryptionConfiguration = encryptionConfiguration,
        expectedBucketOwner = expectedBucketOwner,
        forceDestroy = forceDestroy,
        name = name,
        properties = properties,
    )
}
