@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NamedQuery].
 */
@PulumiTagMarker
public class NamedQueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamedQueryArgs = NamedQueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamedQueryArgsBuilder.() -> Unit) {
        val builder = NamedQueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NamedQuery {
        val builtJavaResource = com.pulumi.aws.athena.NamedQuery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NamedQuery(builtJavaResource)
    }
}

/**
 * Provides an Athena Named Query resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.NamedQuery;
 * import com.pulumi.aws.athena.NamedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hogeBucketV2 = new BucketV2("hogeBucketV2");
 *         var testKey = new Key("testKey", KeyArgs.builder()
 *             .deletionWindowInDays(7)
 *             .description("Athena KMS Key")
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup", WorkgroupArgs.builder()
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(testKey.arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var hogeDatabase = new Database("hogeDatabase", DatabaseArgs.builder()
 *             .name("users")
 *             .bucket(hogeBucketV2.id())
 *             .build());
 *         var foo = new NamedQuery("foo", NamedQueryArgs.builder()
 *             .workgroup(testWorkgroup.id())
 *             .database(hogeDatabase.name())
 *             .query(hogeDatabase.name().applyValue(name -> String.format("SELECT * FROM %s limit 10;", name)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Named Query using the query ID. For example:
 * ```sh
 *  $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
 * ```
 *
 */
public class NamedQuery internal constructor(
    override val javaResource: com.pulumi.aws.athena.NamedQuery,
) : KotlinCustomResource(javaResource, NamedQueryMapper) {
    /**
     * Database to which the query belongs.
     */
    public val database: Output<String>
        get() = javaResource.database().applyValue({ args0 -> args0 })

    /**
     * Brief explanation of the query. Maximum length of 1024.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Plain language name for the query. Maximum length of 128.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * Workgroup to which the query belongs. Defaults to `primary`
     */
    public val workgroup: Output<String>?
        get() = javaResource.workgroup().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NamedQueryMapper : ResourceMapper<NamedQuery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.athena.NamedQuery::class == javaResource::class

    override fun map(javaResource: Resource): NamedQuery = NamedQuery(
        javaResource as
            com.pulumi.aws.athena.NamedQuery,
    )
}

/**
 * @see [NamedQuery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamedQuery].
 */
public suspend fun namedQuery(name: String, block: suspend NamedQueryResourceBuilder.() -> Unit):
    NamedQuery {
    val builder = NamedQueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamedQuery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namedQuery(name: String): NamedQuery {
    val builder = NamedQueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
