@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.NamedQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Athena Named Query resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.NamedQuery;
 * import com.pulumi.aws.athena.NamedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hogeBucketV2 = new BucketV2("hogeBucketV2");
 *         var testKey = new Key("testKey", KeyArgs.builder()
 *             .deletionWindowInDays(7)
 *             .description("Athena KMS Key")
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup", WorkgroupArgs.builder()
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(testKey.arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var hogeDatabase = new Database("hogeDatabase", DatabaseArgs.builder()
 *             .name("users")
 *             .bucket(hogeBucketV2.id())
 *             .build());
 *         var foo = new NamedQuery("foo", NamedQueryArgs.builder()
 *             .workgroup(testWorkgroup.id())
 *             .database(hogeDatabase.name())
 *             .query(hogeDatabase.name().applyValue(name -> String.format("SELECT * FROM %s limit 10;", name)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Named Query using the query ID. For example:
 * ```sh
 *  $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
 * ```
 * @property database Database to which the query belongs.
 * @property description Brief explanation of the query. Maximum length of 1024.
 * @property name Plain language name for the query. Maximum length of 128.
 * @property query Text of the query itself. In other words, all query statements. Maximum length of 262144.
 * @property workgroup Workgroup to which the query belongs. Defaults to `primary`
 */
public data class NamedQueryArgs(
    public val database: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val query: Output<String>? = null,
    public val workgroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.NamedQueryArgs> {
    override fun toJava(): com.pulumi.aws.athena.NamedQueryArgs =
        com.pulumi.aws.athena.NamedQueryArgs.builder()
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .workgroup(workgroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamedQueryArgs].
 */
@PulumiTagMarker
public class NamedQueryArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var query: Output<String>? = null

    private var workgroup: Output<String>? = null

    /**
     * @param value Database to which the query belongs.
     */
    @JvmName("kxtltthlajmvbmxt")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value Brief explanation of the query. Maximum length of 1024.
     */
    @JvmName("lgprbpinsbeubfxg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Plain language name for the query. Maximum length of 128.
     */
    @JvmName("rpsovakdfqjsuhdq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    @JvmName("tbrhkksntgomqqaq")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Workgroup to which the query belongs. Defaults to `primary`
     */
    @JvmName("pjrqetqgeuognkyk")
    public suspend fun workgroup(`value`: Output<String>) {
        this.workgroup = value
    }

    /**
     * @param value Database to which the query belongs.
     */
    @JvmName("xpssjjjixvapfknl")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Brief explanation of the query. Maximum length of 1024.
     */
    @JvmName("ydrpsoaabtpqeghn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Plain language name for the query. Maximum length of 128.
     */
    @JvmName("ylxtfavpafcivxno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    @JvmName("mcvqknxmjixbxrpu")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Workgroup to which the query belongs. Defaults to `primary`
     */
    @JvmName("hopjkafvmtcivdcl")
    public suspend fun workgroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroup = mapped
    }

    internal fun build(): NamedQueryArgs = NamedQueryArgs(
        database = database,
        description = description,
        name = name,
        query = query,
        workgroup = workgroup,
    )
}
