@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PreparedStatement].
 */
@PulumiTagMarker
public class PreparedStatementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PreparedStatementArgs = PreparedStatementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PreparedStatementArgsBuilder.() -> Unit) {
        val builder = PreparedStatementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PreparedStatement {
        val builtJavaResource = com.pulumi.aws.athena.PreparedStatement(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PreparedStatement(builtJavaResource)
    }
}

/**
 * Resource for managing an Athena Prepared Statement.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.PreparedStatement;
 * import com.pulumi.aws.athena.PreparedStatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucketV2 = new BucketV2("testBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup");
 *         var testDatabase = new Database("testDatabase", DatabaseArgs.builder()
 *             .name("example")
 *             .bucket(testBucketV2.bucket())
 *             .build());
 *         var testPreparedStatement = new PreparedStatement("testPreparedStatement", PreparedStatementArgs.builder()
 *             .queryStatement(testDatabase.name().applyValue(name -> String.format("SELECT * FROM %s WHERE x = ?", name)))
 *             .workgroup(testWorkgroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Prepared Statement using the `WORKGROUP-NAME/STATEMENT-NAME`. For example:
 * ```sh
 *  $ pulumi import aws:athena/preparedStatement:PreparedStatement example 12345abcde/example
 * ```
 *
 */
public class PreparedStatement internal constructor(
    override val javaResource: com.pulumi.aws.athena.PreparedStatement,
) : KotlinCustomResource(javaResource, PreparedStatementMapper) {
    /**
     * Brief explanation of prepared statement. Maximum length of 1024.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the prepared statement. Maximum length of 256.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The query string for the prepared statement.
     */
    public val queryStatement: Output<String>
        get() = javaResource.queryStatement().applyValue({ args0 -> args0 })

    /**
     * The name of the workgroup to which the prepared statement belongs.
     */
    public val workgroup: Output<String>
        get() = javaResource.workgroup().applyValue({ args0 -> args0 })
}

public object PreparedStatementMapper : ResourceMapper<PreparedStatement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.athena.PreparedStatement::class == javaResource::class

    override fun map(javaResource: Resource): PreparedStatement = PreparedStatement(
        javaResource as
            com.pulumi.aws.athena.PreparedStatement,
    )
}

/**
 * @see [PreparedStatement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PreparedStatement].
 */
public suspend fun preparedStatement(
    name: String,
    block: suspend PreparedStatementResourceBuilder.() -> Unit,
): PreparedStatement {
    val builder = PreparedStatementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PreparedStatement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun preparedStatement(name: String): PreparedStatement {
    val builder = PreparedStatementResourceBuilder()
    builder.name(name)
    return builder.build()
}
