@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.PreparedStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an Athena Prepared Statement.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.PreparedStatement;
 * import com.pulumi.aws.athena.PreparedStatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucketV2 = new BucketV2("testBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup");
 *         var testDatabase = new Database("testDatabase", DatabaseArgs.builder()
 *             .name("example")
 *             .bucket(testBucketV2.bucket())
 *             .build());
 *         var testPreparedStatement = new PreparedStatement("testPreparedStatement", PreparedStatementArgs.builder()
 *             .queryStatement(testDatabase.name().applyValue(name -> String.format("SELECT * FROM %s WHERE x = ?", name)))
 *             .workgroup(testWorkgroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Prepared Statement using the `WORKGROUP-NAME/STATEMENT-NAME`. For example:
 * ```sh
 *  $ pulumi import aws:athena/preparedStatement:PreparedStatement example 12345abcde/example
 * ```
 * @property description Brief explanation of prepared statement. Maximum length of 1024.
 * @property name The name of the prepared statement. Maximum length of 256.
 * @property queryStatement The query string for the prepared statement.
 * @property workgroup The name of the workgroup to which the prepared statement belongs.
 */
public data class PreparedStatementArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val queryStatement: Output<String>? = null,
    public val workgroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.PreparedStatementArgs> {
    override fun toJava(): com.pulumi.aws.athena.PreparedStatementArgs =
        com.pulumi.aws.athena.PreparedStatementArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .queryStatement(queryStatement?.applyValue({ args0 -> args0 }))
            .workgroup(workgroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PreparedStatementArgs].
 */
@PulumiTagMarker
public class PreparedStatementArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var queryStatement: Output<String>? = null

    private var workgroup: Output<String>? = null

    /**
     * @param value Brief explanation of prepared statement. Maximum length of 1024.
     */
    @JvmName("isnjonmamvwrtxkr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the prepared statement. Maximum length of 256.
     */
    @JvmName("pcbllcskuqcrmvoy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query string for the prepared statement.
     */
    @JvmName("jwcnjkvyyclobibp")
    public suspend fun queryStatement(`value`: Output<String>) {
        this.queryStatement = value
    }

    /**
     * @param value The name of the workgroup to which the prepared statement belongs.
     */
    @JvmName("ocykqpxlpckcxelt")
    public suspend fun workgroup(`value`: Output<String>) {
        this.workgroup = value
    }

    /**
     * @param value Brief explanation of prepared statement. Maximum length of 1024.
     */
    @JvmName("svypchyoqfcsxrvb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the prepared statement. Maximum length of 256.
     */
    @JvmName("ghcgrgqwlnuemmkw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The query string for the prepared statement.
     */
    @JvmName("dskhrjtcyqixcfct")
    public suspend fun queryStatement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStatement = mapped
    }

    /**
     * @param value The name of the workgroup to which the prepared statement belongs.
     */
    @JvmName("sgascukanrgvfdca")
    public suspend fun workgroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroup = mapped
    }

    internal fun build(): PreparedStatementArgs = PreparedStatementArgs(
        description = description,
        name = name,
        queryStatement = queryStatement,
        workgroup = workgroup,
    )
}
