@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfiguration
import com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workgroup].
 */
@PulumiTagMarker
public class WorkgroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkgroupArgs = WorkgroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkgroupArgsBuilder.() -> Unit) {
        val builder = WorkgroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workgroup {
        val builtJavaResource = com.pulumi.aws.athena.Workgroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workgroup(builtJavaResource)
    }
}

/**
 * Provides an Athena Workgroup.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .enforceWorkgroupConfiguration(true)
 *                 .publishCloudwatchMetricsEnabled(true)
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .outputLocation(String.format("s3://%s/output/", aws_s3_bucket.example().bucket()))
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Workgroups using their name. For example:
 * ```sh
 *  $ pulumi import aws:athena/workgroup:Workgroup example example
 * ```
 *
 */
public class Workgroup internal constructor(
    override val javaResource: com.pulumi.aws.athena.Workgroup,
) : KotlinCustomResource(javaResource, WorkgroupMapper) {
    /**
     * ARN of the workgroup
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block with various settings for the workgroup. Documented below.
     */
    public val configuration: Output<WorkgroupConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Description of the workgroup.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Option to delete the workgroup and its contents even if the workgroup contains any named queries.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the workgroup.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the workgroup. Valid values are `DISABLED` or `ENABLED`. Defaults to `ENABLED`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags for the workgroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object WorkgroupMapper : ResourceMapper<Workgroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.athena.Workgroup::class == javaResource::class

    override fun map(javaResource: Resource): Workgroup = Workgroup(
        javaResource as
            com.pulumi.aws.athena.Workgroup,
    )
}

/**
 * @see [Workgroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workgroup].
 */
public suspend fun workgroup(name: String, block: suspend WorkgroupResourceBuilder.() -> Unit):
    Workgroup {
    val builder = WorkgroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workgroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workgroup(name: String): Workgroup {
    val builder = WorkgroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
