@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.WorkgroupArgs.builder
import com.pulumi.aws.athena.kotlin.inputs.WorkgroupConfigurationArgs
import com.pulumi.aws.athena.kotlin.inputs.WorkgroupConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Athena Workgroup.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .enforceWorkgroupConfiguration(true)
 *                 .publishCloudwatchMetricsEnabled(true)
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .outputLocation(String.format("s3://%s/output/", aws_s3_bucket.example().bucket()))
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Athena Workgroups using their name. For example:
 * ```sh
 *  $ pulumi import aws:athena/workgroup:Workgroup example example
 * ```
 * @property configuration Configuration block with various settings for the workgroup. Documented below.
 * @property description Description of the workgroup.
 * @property forceDestroy Option to delete the workgroup and its contents even if the workgroup contains any named queries.
 * @property name Name of the workgroup.
 * @property state State of the workgroup. Valid values are `DISABLED` or `ENABLED`. Defaults to `ENABLED`.
 * @property tags Key-value map of resource tags for the workgroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkgroupArgs(
    public val configuration: Output<WorkgroupConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.WorkgroupArgs> {
    override fun toJava(): com.pulumi.aws.athena.WorkgroupArgs =
        com.pulumi.aws.athena.WorkgroupArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkgroupArgs].
 */
@PulumiTagMarker
public class WorkgroupArgsBuilder internal constructor() {
    private var configuration: Output<WorkgroupConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block with various settings for the workgroup. Documented below.
     */
    @JvmName("xjhfgqpcffwbwukb")
    public suspend fun configuration(`value`: Output<WorkgroupConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Description of the workgroup.
     */
    @JvmName("umicbhfnjkfnqfms")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Option to delete the workgroup and its contents even if the workgroup contains any named queries.
     */
    @JvmName("opamwjmllclggdni")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the workgroup.
     */
    @JvmName("soalvvcuklfalias")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value State of the workgroup. Valid values are `DISABLED` or `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("wyelqklbuhlxesmy")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Key-value map of resource tags for the workgroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kdvynbucbxlfltjr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with various settings for the workgroup. Documented below.
     */
    @JvmName("qqwihmfjxcxsnhnm")
    public suspend fun configuration(`value`: WorkgroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration block with various settings for the workgroup. Documented below.
     */
    @JvmName("kjsqjeyvlqbdalbv")
    public suspend fun configuration(argument: suspend WorkgroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkgroupConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Description of the workgroup.
     */
    @JvmName("mytnsrxguevxdtad")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Option to delete the workgroup and its contents even if the workgroup contains any named queries.
     */
    @JvmName("anjlchypohpxedop")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the workgroup.
     */
    @JvmName("otrcouwwpinlukso")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value State of the workgroup. Valid values are `DISABLED` or `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("ybcdddaduiorcuyi")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Key-value map of resource tags for the workgroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mbvoeoiirfwfblwp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the workgroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pcdjrsjsdedkfbdi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkgroupArgs = WorkgroupArgs(
        configuration = configuration,
        description = description,
        forceDestroy = forceDestroy,
        name = name,
        state = state,
        tags = tags,
    )
}
