@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.DatabaseAclConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3AclOption Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
 * > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
 */
public data class DatabaseAclConfigurationArgs(
    public val s3AclOption: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.DatabaseAclConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.DatabaseAclConfigurationArgs =
        com.pulumi.aws.athena.inputs.DatabaseAclConfigurationArgs.builder()
            .s3AclOption(s3AclOption.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseAclConfigurationArgs].
 */
@PulumiTagMarker
public class DatabaseAclConfigurationArgsBuilder internal constructor() {
    private var s3AclOption: Output<String>? = null

    /**
     * @param value Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
     * > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
     */
    @JvmName("kvaohotdkewqulks")
    public suspend fun s3AclOption(`value`: Output<String>) {
        this.s3AclOption = value
    }

    /**
     * @param value Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
     * > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
     */
    @JvmName("vruakaaiojnynmxn")
    public suspend fun s3AclOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3AclOption = mapped
    }

    internal fun build(): DatabaseAclConfigurationArgs = DatabaseAclConfigurationArgs(
        s3AclOption = s3AclOption ?: throw PulumiNullFieldException("s3AclOption"),
    )
}
