@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.DatabaseEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionOption Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
 * @property kmsKey KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
 */
public data class DatabaseEncryptionConfigurationArgs(
    public val encryptionOption: Output<String>,
    public val kmsKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.DatabaseEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.DatabaseEncryptionConfigurationArgs =
        com.pulumi.aws.athena.inputs.DatabaseEncryptionConfigurationArgs.builder()
            .encryptionOption(encryptionOption.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class DatabaseEncryptionConfigurationArgsBuilder internal constructor() {
    private var encryptionOption: Output<String>? = null

    private var kmsKey: Output<String>? = null

    /**
     * @param value Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
     */
    @JvmName("qbypvdshemdvcfqx")
    public suspend fun encryptionOption(`value`: Output<String>) {
        this.encryptionOption = value
    }

    /**
     * @param value KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
     */
    @JvmName("bqjmvmiuojqxdthl")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
     */
    @JvmName("xrltuwvqfrfvgyaf")
    public suspend fun encryptionOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionOption = mapped
    }

    /**
     * @param value KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
     */
    @JvmName("tjhwvunoicgjpmln")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    internal fun build(): DatabaseEncryptionConfigurationArgs = DatabaseEncryptionConfigurationArgs(
        encryptionOption = encryptionOption ?: throw PulumiNullFieldException("encryptionOption"),
        kmsKey = kmsKey,
    )
}
