@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.GetNamedQueryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNamedQuery.
 * @property name The plain language name for the query. Maximum length of 128.
 * @property workgroup The workgroup to which the query belongs. Defaults to `primary`.
 */
public data class GetNamedQueryPlainArgs(
    public val name: String,
    public val workgroup: String? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.GetNamedQueryPlainArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.GetNamedQueryPlainArgs =
        com.pulumi.aws.athena.inputs.GetNamedQueryPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .workgroup(workgroup?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamedQueryPlainArgs].
 */
@PulumiTagMarker
public class GetNamedQueryPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var workgroup: String? = null

    /**
     * @param value The plain language name for the query. Maximum length of 128.
     */
    @JvmName("vipdfkerrevsyfao")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The workgroup to which the query belongs. Defaults to `primary`.
     */
    @JvmName("lclgatxtcqmnffdh")
    public suspend fun workgroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.workgroup = mapped
    }

    internal fun build(): GetNamedQueryPlainArgs = GetNamedQueryPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        workgroup = workgroup,
    )
}
