@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bytesScannedCutoffPerQuery Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
 * @property enforceWorkgroupConfiguration Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
 * @property engineVersion Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
 * @property executionRole Role used in a notebook session for accessing the user's resources.
 * @property publishCloudwatchMetricsEnabled Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
 * @property requesterPaysEnabled If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
 * @property resultConfiguration Configuration block with result settings. See Result Configuration below.
 */
public data class WorkgroupConfigurationArgs(
    public val bytesScannedCutoffPerQuery: Output<Int>? = null,
    public val enforceWorkgroupConfiguration: Output<Boolean>? = null,
    public val engineVersion: Output<WorkgroupConfigurationEngineVersionArgs>? = null,
    public val executionRole: Output<String>? = null,
    public val publishCloudwatchMetricsEnabled: Output<Boolean>? = null,
    public val requesterPaysEnabled: Output<Boolean>? = null,
    public val resultConfiguration: Output<WorkgroupConfigurationResultConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs =
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs.builder()
            .bytesScannedCutoffPerQuery(bytesScannedCutoffPerQuery?.applyValue({ args0 -> args0 }))
            .enforceWorkgroupConfiguration(enforceWorkgroupConfiguration?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRole(executionRole?.applyValue({ args0 -> args0 }))
            .publishCloudwatchMetricsEnabled(publishCloudwatchMetricsEnabled?.applyValue({ args0 -> args0 }))
            .requesterPaysEnabled(requesterPaysEnabled?.applyValue({ args0 -> args0 }))
            .resultConfiguration(
                resultConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkgroupConfigurationArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigurationArgsBuilder internal constructor() {
    private var bytesScannedCutoffPerQuery: Output<Int>? = null

    private var enforceWorkgroupConfiguration: Output<Boolean>? = null

    private var engineVersion: Output<WorkgroupConfigurationEngineVersionArgs>? = null

    private var executionRole: Output<String>? = null

    private var publishCloudwatchMetricsEnabled: Output<Boolean>? = null

    private var requesterPaysEnabled: Output<Boolean>? = null

    private var resultConfiguration: Output<WorkgroupConfigurationResultConfigurationArgs>? = null

    /**
     * @param value Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
     */
    @JvmName("hqrmlvqtxwqjbsax")
    public suspend fun bytesScannedCutoffPerQuery(`value`: Output<Int>) {
        this.bytesScannedCutoffPerQuery = value
    }

    /**
     * @param value Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
     */
    @JvmName("yyfjdqjubyjxsyja")
    public suspend fun enforceWorkgroupConfiguration(`value`: Output<Boolean>) {
        this.enforceWorkgroupConfiguration = value
    }

    /**
     * @param value Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
     */
    @JvmName("yilyavntykrttoyc")
    public suspend fun engineVersion(`value`: Output<WorkgroupConfigurationEngineVersionArgs>) {
        this.engineVersion = value
    }

    /**
     * @param value Role used in a notebook session for accessing the user's resources.
     */
    @JvmName("rereuxbxusresivi")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
     */
    @JvmName("ongwfnloxbnnepwq")
    public suspend fun publishCloudwatchMetricsEnabled(`value`: Output<Boolean>) {
        this.publishCloudwatchMetricsEnabled = value
    }

    /**
     * @param value If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
     */
    @JvmName("wtsssneggwyplybr")
    public suspend fun requesterPaysEnabled(`value`: Output<Boolean>) {
        this.requesterPaysEnabled = value
    }

    /**
     * @param value Configuration block with result settings. See Result Configuration below.
     */
    @JvmName("hlcpqjvfssookeur")
    public suspend
    fun resultConfiguration(`value`: Output<WorkgroupConfigurationResultConfigurationArgs>) {
        this.resultConfiguration = value
    }

    /**
     * @param value Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
     */
    @JvmName("ajybemgwesmvsynd")
    public suspend fun bytesScannedCutoffPerQuery(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytesScannedCutoffPerQuery = mapped
    }

    /**
     * @param value Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
     */
    @JvmName("aeerisfgxnvedwpa")
    public suspend fun enforceWorkgroupConfiguration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceWorkgroupConfiguration = mapped
    }

    /**
     * @param value Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
     */
    @JvmName("doikcxkulnymvayt")
    public suspend fun engineVersion(`value`: WorkgroupConfigurationEngineVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param argument Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
     */
    @JvmName("txbqafglnjcoemkf")
    public suspend
    fun engineVersion(argument: suspend WorkgroupConfigurationEngineVersionArgsBuilder.() -> Unit) {
        val toBeMapped = WorkgroupConfigurationEngineVersionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.engineVersion = mapped
    }

    /**
     * @param value Role used in a notebook session for accessing the user's resources.
     */
    @JvmName("pfpnhidrfvfenrwa")
    public suspend fun executionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
     */
    @JvmName("uktebpitmqkqnmnr")
    public suspend fun publishCloudwatchMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishCloudwatchMetricsEnabled = mapped
    }

    /**
     * @param value If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
     */
    @JvmName("kahnsvmouijrvccf")
    public suspend fun requesterPaysEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requesterPaysEnabled = mapped
    }

    /**
     * @param value Configuration block with result settings. See Result Configuration below.
     */
    @JvmName("mkvxyjdhojnobodj")
    public suspend fun resultConfiguration(`value`: WorkgroupConfigurationResultConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resultConfiguration = mapped
    }

    /**
     * @param argument Configuration block with result settings. See Result Configuration below.
     */
    @JvmName("byyykunxfkikvfnc")
    public suspend
    fun resultConfiguration(argument: suspend WorkgroupConfigurationResultConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkgroupConfigurationResultConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resultConfiguration = mapped
    }

    internal fun build(): WorkgroupConfigurationArgs = WorkgroupConfigurationArgs(
        bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery,
        enforceWorkgroupConfiguration = enforceWorkgroupConfiguration,
        engineVersion = engineVersion,
        executionRole = executionRole,
        publishCloudwatchMetricsEnabled = publishCloudwatchMetricsEnabled,
        requesterPaysEnabled = requesterPaysEnabled,
        resultConfiguration = resultConfiguration,
    )
}
