@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property aclConfiguration That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
 * @property encryptionConfiguration Configuration block with encryption settings. See Encryption Configuration below.
 * @property expectedBucketOwner AWS account ID that you expect to be the owner of the Amazon S3 bucket.
 * @property outputLocation Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
 */
public data class WorkgroupConfigurationResultConfigurationArgs(
    public val aclConfiguration:
    Output<WorkgroupConfigurationResultConfigurationAclConfigurationArgs>? = null,
    public val encryptionConfiguration:
    Output<WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val outputLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs =
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs.builder()
            .aclConfiguration(aclConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .outputLocation(outputLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupConfigurationResultConfigurationArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigurationResultConfigurationArgsBuilder internal constructor() {
    private var aclConfiguration:
        Output<WorkgroupConfigurationResultConfigurationAclConfigurationArgs>? = null

    private var encryptionConfiguration:
        Output<WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var outputLocation: Output<String>? = null

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("ysndbngrqowawxwl")
    public suspend
    fun aclConfiguration(`value`: Output<WorkgroupConfigurationResultConfigurationAclConfigurationArgs>) {
        this.aclConfiguration = value
    }

    /**
     * @param value Configuration block with encryption settings. See Encryption Configuration below.
     */
    @JvmName("hiiwljhgqjqcvhja")
    public suspend
    fun encryptionConfiguration(`value`: Output<WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("xkpgwwrlhhbudwao")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
     */
    @JvmName("noecsofhirqrqoya")
    public suspend fun outputLocation(`value`: Output<String>) {
        this.outputLocation = value
    }

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("bllrtdghykstjrva")
    public suspend
    fun aclConfiguration(`value`: WorkgroupConfigurationResultConfigurationAclConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclConfiguration = mapped
    }

    /**
     * @param argument That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("emfldmecdlnygrxm")
    public suspend
    fun aclConfiguration(argument: suspend WorkgroupConfigurationResultConfigurationAclConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkgroupConfigurationResultConfigurationAclConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aclConfiguration = mapped
    }

    /**
     * @param value Configuration block with encryption settings. See Encryption Configuration below.
     */
    @JvmName("pubnfpcgnspqywwr")
    public suspend
    fun encryptionConfiguration(`value`: WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration block with encryption settings. See Encryption Configuration below.
     */
    @JvmName("pvsqrxlrcqcdlgfk")
    public suspend
    fun encryptionConfiguration(argument: suspend WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("mvypipuegmsugire")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
     */
    @JvmName("lrdkrtyphjjuaqpr")
    public suspend fun outputLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputLocation = mapped
    }

    internal fun build(): WorkgroupConfigurationResultConfigurationArgs =
        WorkgroupConfigurationResultConfigurationArgs(
            aclConfiguration = aclConfiguration,
            encryptionConfiguration = encryptionConfiguration,
            expectedBucketOwner = expectedBucketOwner,
            outputLocation = outputLocation,
        )
}
