@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionOption Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
 * @property kmsKeyArn For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
 */
public data class WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs(
    public val encryptionOption: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs =
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
            .encryptionOption(encryptionOption?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgsBuilder internal
constructor() {
    private var encryptionOption: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
     */
    @JvmName("kyssmcnpwlfbwuyp")
    public suspend fun encryptionOption(`value`: Output<String>) {
        this.encryptionOption = value
    }

    /**
     * @param value For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
     */
    @JvmName("hnkcnsfoboishlng")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
     */
    @JvmName("kmaeckibwujvwyfd")
    public suspend fun encryptionOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionOption = mapped
    }

    /**
     * @param value For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
     */
    @JvmName("oxmtnaayhwikamma")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs =
        WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs(
            encryptionOption = encryptionOption,
            kmsKeyArn = kmsKeyArn,
        )
}
