@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3AclOption Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
 * > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
 */
public data class DatabaseAclConfiguration(
    public val s3AclOption: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.athena.outputs.DatabaseAclConfiguration):
            DatabaseAclConfiguration = DatabaseAclConfiguration(
            s3AclOption = javaType.s3AclOption(),
        )
    }
}
