@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionOption Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
 * @property kmsKey KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
 */
public data class DatabaseEncryptionConfiguration(
    public val encryptionOption: String,
    public val kmsKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.athena.outputs.DatabaseEncryptionConfiguration):
            DatabaseEncryptionConfiguration = DatabaseEncryptionConfiguration(
            encryptionOption = javaType.encryptionOption(),
            kmsKey = javaType.kmsKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
