@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getNamedQuery.
 * @property database Database to which the query belongs.
 * @property description Brief explanation of the query.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property querystring
 * @property workgroup
 */
public data class GetNamedQueryResult(
    public val database: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val querystring: String,
    public val workgroup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.athena.outputs.GetNamedQueryResult):
            GetNamedQueryResult = GetNamedQueryResult(
            database = javaType.database(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            querystring = javaType.querystring(),
            workgroup = javaType.workgroup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
