@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property effectiveEngineVersion The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
 * @property selectedEngineVersion Requested engine version. Defaults to `AUTO`.
 */
public data class WorkgroupConfigurationEngineVersion(
    public val effectiveEngineVersion: String? = null,
    public val selectedEngineVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.athena.outputs.WorkgroupConfigurationEngineVersion):
            WorkgroupConfigurationEngineVersion = WorkgroupConfigurationEngineVersion(
            effectiveEngineVersion = javaType.effectiveEngineVersion().map({ args0 -> args0 }).orElse(null),
            selectedEngineVersion = javaType.selectedEngineVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
