@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionOption Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
 * @property kmsKeyArn For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
 */
public data class WorkgroupConfigurationResultConfigurationEncryptionConfiguration(
    public val encryptionOption: String? = null,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.athena.outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration):
            WorkgroupConfigurationResultConfigurationEncryptionConfiguration =
            WorkgroupConfigurationResultConfigurationEncryptionConfiguration(
                encryptionOption = javaType.encryptionOption().map({ args0 -> args0 }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
