@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AccountRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing AWS Audit Manager Account Registration.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration("example");
 *     }
 * }
 * ```
 * ### Deregister On Destroy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import com.pulumi.aws.auditmanager.AccountRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration("example", AccountRegistrationArgs.builder()
 *             .deregisterOnDestroy(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Account Registration resources using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/accountRegistration:AccountRegistration example us-east-1
 * ```
 * @property delegatedAdminAccount Identifier for the delegated administrator account.
 * @property deregisterOnDestroy Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
 * @property kmsKey KMS key identifier.
 */
public data class AccountRegistrationArgs(
    public val delegatedAdminAccount: Output<String>? = null,
    public val deregisterOnDestroy: Output<Boolean>? = null,
    public val kmsKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AccountRegistrationArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AccountRegistrationArgs =
        com.pulumi.aws.auditmanager.AccountRegistrationArgs.builder()
            .delegatedAdminAccount(delegatedAdminAccount?.applyValue({ args0 -> args0 }))
            .deregisterOnDestroy(deregisterOnDestroy?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountRegistrationArgs].
 */
@PulumiTagMarker
public class AccountRegistrationArgsBuilder internal constructor() {
    private var delegatedAdminAccount: Output<String>? = null

    private var deregisterOnDestroy: Output<Boolean>? = null

    private var kmsKey: Output<String>? = null

    /**
     * @param value Identifier for the delegated administrator account.
     */
    @JvmName("cpfppntjxqfbqvhn")
    public suspend fun delegatedAdminAccount(`value`: Output<String>) {
        this.delegatedAdminAccount = value
    }

    /**
     * @param value Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
     */
    @JvmName("xnaapsgwhlypkivc")
    public suspend fun deregisterOnDestroy(`value`: Output<Boolean>) {
        this.deregisterOnDestroy = value
    }

    /**
     * @param value KMS key identifier.
     */
    @JvmName("mbvvqjnrivbktnpy")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value Identifier for the delegated administrator account.
     */
    @JvmName("xjpndjndhqgyycoa")
    public suspend fun delegatedAdminAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedAdminAccount = mapped
    }

    /**
     * @param value Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
     */
    @JvmName("rcclyudeaiegiylk")
    public suspend fun deregisterOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deregisterOnDestroy = mapped
    }

    /**
     * @param value KMS key identifier.
     */
    @JvmName("fmnfgxwknhuwvqpc")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    internal fun build(): AccountRegistrationArgs = AccountRegistrationArgs(
        delegatedAdminAccount = delegatedAdminAccount,
        deregisterOnDestroy = deregisterOnDestroy,
        kmsKey = kmsKey,
    )
}
