@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentAssessmentReportsDestination
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentRole
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentRolesAll
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentScope
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentAssessmentReportsDestination.Companion.toKotlin as assessmentAssessmentReportsDestinationToKotlin
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentRole.Companion.toKotlin as assessmentRoleToKotlin
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentRolesAll.Companion.toKotlin as assessmentRolesAllToKotlin
import com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentScope.Companion.toKotlin as assessmentScopeToKotlin

/**
 * Builder for [Assessment].
 */
@PulumiTagMarker
public class AssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentArgs = AssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentArgsBuilder.() -> Unit) {
        val builder = AssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Assessment {
        val builtJavaResource = com.pulumi.aws.auditmanager.Assessment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Assessment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Assessment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Assessment;
 * import com.pulumi.aws.auditmanager.AssessmentArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Assessment("test", AssessmentArgs.builder()
 *             .assessmentReportsDestination(AssessmentAssessmentReportsDestinationArgs.builder()
 *                 .destination(String.format("s3://%s", aws_s3_bucket.test().id()))
 *                 .destinationType("S3")
 *                 .build())
 *             .frameworkId(aws_auditmanager_framework.test().id())
 *             .roles(AssessmentRoleArgs.builder()
 *                 .roleArn(aws_iam_role.test().arn())
 *                 .roleType("PROCESS_OWNER")
 *                 .build())
 *             .scope(AssessmentScopeArgs.builder()
 *                 .awsAccounts(AssessmentScopeAwsAccountArgs.builder()
 *                     .id(data.aws_caller_identity().current().account_id())
 *                     .build())
 *                 .awsServices(AssessmentScopeAwsServiceArgs.builder()
 *                     .serviceName("S3")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessments using the assessment `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/assessment:Assessment example abc123-de45
 * ```
 *
 */
public class Assessment internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.Assessment,
) : KotlinCustomResource(javaResource, AssessmentMapper) {
    /**
     * Amazon Resource Name (ARN) of the assessment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    public val assessmentReportsDestination: Output<AssessmentAssessmentReportsDestination>?
        get() = javaResource.assessmentReportsDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> assessmentAssessmentReportsDestinationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Description of the assessment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier of the framework the assessment will be created from.
     */
    public val frameworkId: Output<String>
        get() = javaResource.frameworkId().applyValue({ args0 -> args0 })

    /**
     * Name of the assessment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of roles for the assessment. See `roles` below.
     */
    public val roles: Output<List<AssessmentRole>>
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assessmentRoleToKotlin(args0)
                })
            })
        })

    /**
     * Complete list of all roles with access to the assessment. This includes both roles explicitly configured via the `roles` block, and any roles which have access to all Audit Manager assessments by default.
     */
    public val rolesAlls: Output<List<AssessmentRolesAll>>
        get() = javaResource.rolesAlls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assessmentRolesAllToKotlin(args0)
                })
            })
        })

    /**
     * Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    public val scope: Output<AssessmentScope>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assessmentScopeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Status of the assessment. Valid values are `ACTIVE` and `INACTIVE`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AssessmentMapper : ResourceMapper<Assessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.Assessment::class == javaResource::class

    override fun map(javaResource: Resource): Assessment = Assessment(
        javaResource as
            com.pulumi.aws.auditmanager.Assessment,
    )
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Assessment].
 */
public suspend fun assessment(name: String, block: suspend AssessmentResourceBuilder.() -> Unit):
    Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessment(name: String): Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
