@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AssessmentArgs.builder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentAssessmentReportsDestinationArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentAssessmentReportsDestinationArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentRoleArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentRoleArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentScopeArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Assessment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Assessment;
 * import com.pulumi.aws.auditmanager.AssessmentArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Assessment("test", AssessmentArgs.builder()
 *             .assessmentReportsDestination(AssessmentAssessmentReportsDestinationArgs.builder()
 *                 .destination(String.format("s3://%s", aws_s3_bucket.test().id()))
 *                 .destinationType("S3")
 *                 .build())
 *             .frameworkId(aws_auditmanager_framework.test().id())
 *             .roles(AssessmentRoleArgs.builder()
 *                 .roleArn(aws_iam_role.test().arn())
 *                 .roleType("PROCESS_OWNER")
 *                 .build())
 *             .scope(AssessmentScopeArgs.builder()
 *                 .awsAccounts(AssessmentScopeAwsAccountArgs.builder()
 *                     .id(data.aws_caller_identity().current().account_id())
 *                     .build())
 *                 .awsServices(AssessmentScopeAwsServiceArgs.builder()
 *                     .serviceName("S3")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessments using the assessment `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/assessment:Assessment example abc123-de45
 * ```
 * @property assessmentReportsDestination Assessment report storage destination configuration. See `assessment_reports_destination` below.
 * @property description Description of the assessment.
 * @property frameworkId Unique identifier of the framework the assessment will be created from.
 * @property name Name of the assessment.
 * @property roles List of roles for the assessment. See `roles` below.
 * @property scope Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AssessmentArgs(
    public val assessmentReportsDestination: Output<AssessmentAssessmentReportsDestinationArgs>? =
        null,
    public val description: Output<String>? = null,
    public val frameworkId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roles: Output<List<AssessmentRoleArgs>>? = null,
    public val scope: Output<AssessmentScopeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AssessmentArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AssessmentArgs =
        com.pulumi.aws.auditmanager.AssessmentArgs.builder()
            .assessmentReportsDestination(
                assessmentReportsDestination?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .frameworkId(frameworkId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssessmentArgs].
 */
@PulumiTagMarker
public class AssessmentArgsBuilder internal constructor() {
    private var assessmentReportsDestination: Output<AssessmentAssessmentReportsDestinationArgs>? =
        null

    private var description: Output<String>? = null

    private var frameworkId: Output<String>? = null

    private var name: Output<String>? = null

    private var roles: Output<List<AssessmentRoleArgs>>? = null

    private var scope: Output<AssessmentScopeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("oymjacsglskebthv")
    public suspend
    fun assessmentReportsDestination(`value`: Output<AssessmentAssessmentReportsDestinationArgs>) {
        this.assessmentReportsDestination = value
    }

    /**
     * @param value Description of the assessment.
     */
    @JvmName("fxxkupkhmpxinnxg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier of the framework the assessment will be created from.
     */
    @JvmName("vowpjinlvgqsjjbh")
    public suspend fun frameworkId(`value`: Output<String>) {
        this.frameworkId = value
    }

    /**
     * @param value Name of the assessment.
     */
    @JvmName("xmknejlrotjebwec")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of roles for the assessment. See `roles` below.
     */
    @JvmName("curqrceoigesreqw")
    public suspend fun roles(`value`: Output<List<AssessmentRoleArgs>>) {
        this.roles = value
    }

    @JvmName("yjqsmkmwcvftsahh")
    public suspend fun roles(vararg values: Output<AssessmentRoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values List of roles for the assessment. See `roles` below.
     */
    @JvmName("inpaqkefxnjpbvle")
    public suspend fun roles(values: List<Output<AssessmentRoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("vguovimalxyolgdc")
    public suspend fun scope(`value`: Output<AssessmentScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jvwnpjucbbxiylat")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("djijhdwhvybtkyyr")
    public suspend
    fun assessmentReportsDestination(`value`: AssessmentAssessmentReportsDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentReportsDestination = mapped
    }

    /**
     * @param argument Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("wfvaqlorddqummpv")
    public suspend
    fun assessmentReportsDestination(argument: suspend AssessmentAssessmentReportsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentAssessmentReportsDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.assessmentReportsDestination = mapped
    }

    /**
     * @param value Description of the assessment.
     */
    @JvmName("vmmjephtajlftgvo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier of the framework the assessment will be created from.
     */
    @JvmName("xvsvrwqggutboant")
    public suspend fun frameworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameworkId = mapped
    }

    /**
     * @param value Name of the assessment.
     */
    @JvmName("ofncusbkgbwwrisj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of roles for the assessment. See `roles` below.
     */
    @JvmName("rrhfhwhfqmserfpj")
    public suspend fun roles(`value`: List<AssessmentRoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("hurijhdnkbfvylyy")
    public suspend fun roles(argument: List<suspend AssessmentRoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("gyjijnxghhyeheam")
    public suspend fun roles(vararg argument: suspend AssessmentRoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssessmentRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("vyfrgaxmwhpssjpm")
    public suspend fun roles(argument: suspend AssessmentRoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssessmentRoleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values List of roles for the assessment. See `roles` below.
     */
    @JvmName("girrvgmqusukbjsq")
    public suspend fun roles(vararg values: AssessmentRoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("ulhgbmfewvsmjbbx")
    public suspend fun scope(`value`: AssessmentScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("bayldodqvmdsaebp")
    public suspend fun scope(argument: suspend AssessmentScopeArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxiickwmsxknwiya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("egrbiwekmoejixdf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssessmentArgs = AssessmentArgs(
        assessmentReportsDestination = assessmentReportsDestination,
        description = description,
        frameworkId = frameworkId,
        name = name,
        roles = roles,
        scope = scope,
        tags = tags,
    )
}
