@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AssessmentDelegation].
 */
@PulumiTagMarker
public class AssessmentDelegationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentDelegationArgs = AssessmentDelegationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentDelegationArgsBuilder.() -> Unit) {
        val builder = AssessmentDelegationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AssessmentDelegation {
        val builtJavaResource =
            com.pulumi.aws.auditmanager.AssessmentDelegation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssessmentDelegation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Assessment Delegation.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentDelegation;
 * import com.pulumi.aws.auditmanager.AssessmentDelegationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentDelegation("example", AssessmentDelegationArgs.builder()
 *             .assessmentId(aws_auditmanager_assessment.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .roleType("RESOURCE_OWNER")
 *             .controlSetId("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessment Delegation using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/assessmentDelegation:AssessmentDelegation example abcdef-123456,arn:aws:iam::012345678901:role/example,example
 * ```
 *
 */
public class AssessmentDelegation internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.AssessmentDelegation,
) : KotlinCustomResource(javaResource, AssessmentDelegationMapper) {
    /**
     * Identifier for the assessment.
     */
    public val assessmentId: Output<String>
        get() = javaResource.assessmentId().applyValue({ args0 -> args0 })

    /**
     * Comment describing the delegation request.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
     */
    public val controlSetId: Output<String>
        get() = javaResource.controlSetId().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the delegation.
     */
    public val delegationId: Output<String>
        get() = javaResource.delegationId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM role.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
     * The following arguments are optional:
     */
    public val roleType: Output<String>
        get() = javaResource.roleType().applyValue({ args0 -> args0 })

    /**
     * Status of the delegation.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AssessmentDelegationMapper : ResourceMapper<AssessmentDelegation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.AssessmentDelegation::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentDelegation = AssessmentDelegation(
        javaResource
            as com.pulumi.aws.auditmanager.AssessmentDelegation,
    )
}

/**
 * @see [AssessmentDelegation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentDelegation].
 */
public suspend fun assessmentDelegation(
    name: String,
    block: suspend AssessmentDelegationResourceBuilder.() -> Unit,
): AssessmentDelegation {
    val builder = AssessmentDelegationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentDelegation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentDelegation(name: String): AssessmentDelegation {
    val builder = AssessmentDelegationResourceBuilder()
    builder.name(name)
    return builder.build()
}
