@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AssessmentReport].
 */
@PulumiTagMarker
public class AssessmentReportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentReportArgs = AssessmentReportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentReportArgsBuilder.() -> Unit) {
        val builder = AssessmentReportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AssessmentReport {
        val builtJavaResource = com.pulumi.aws.auditmanager.AssessmentReport(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AssessmentReport(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Assessment Report.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentReport;
 * import com.pulumi.aws.auditmanager.AssessmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AssessmentReport("test", AssessmentReportArgs.builder()
 *             .assessmentId(aws_auditmanager_assessment.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessment Reports using the assessment report `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/assessmentReport:AssessmentReport example abc123-de45
 * ```
 *
 */
public class AssessmentReport internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.AssessmentReport,
) : KotlinCustomResource(javaResource, AssessmentReportMapper) {
    /**
     * Unique identifier of the assessment to create the report from.
     * The following arguments are optional:
     */
    public val assessmentId: Output<String>
        get() = javaResource.assessmentId().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the assessment report.
     */
    public val author: Output<String>
        get() = javaResource.author().applyValue({ args0 -> args0 })

    /**
     * Description of the assessment report.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the assessment report.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current status of the specified assessment report. Valid values are `COMPLETE`, `IN_PROGRESS`, and `FAILED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AssessmentReportMapper : ResourceMapper<AssessmentReport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.AssessmentReport::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentReport = AssessmentReport(
        javaResource as
            com.pulumi.aws.auditmanager.AssessmentReport,
    )
}

/**
 * @see [AssessmentReport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentReport].
 */
public suspend fun assessmentReport(
    name: String,
    block: suspend AssessmentReportResourceBuilder.() -> Unit,
): AssessmentReport {
    val builder = AssessmentReportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentReport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentReport(name: String): AssessmentReport {
    val builder = AssessmentReportResourceBuilder()
    builder.name(name)
    return builder.build()
}
