@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AssessmentReportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Assessment Report.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentReport;
 * import com.pulumi.aws.auditmanager.AssessmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AssessmentReport("test", AssessmentReportArgs.builder()
 *             .assessmentId(aws_auditmanager_assessment.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessment Reports using the assessment report `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/assessmentReport:AssessmentReport example abc123-de45
 * ```
 * @property assessmentId Unique identifier of the assessment to create the report from.
 * The following arguments are optional:
 * @property description Description of the assessment report.
 * @property name Name of the assessment report.
 */
public data class AssessmentReportArgs(
    public val assessmentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AssessmentReportArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AssessmentReportArgs =
        com.pulumi.aws.auditmanager.AssessmentReportArgs.builder()
            .assessmentId(assessmentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentReportArgs].
 */
@PulumiTagMarker
public class AssessmentReportArgsBuilder internal constructor() {
    private var assessmentId: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Unique identifier of the assessment to create the report from.
     * The following arguments are optional:
     */
    @JvmName("aosnpcxygfpangec")
    public suspend fun assessmentId(`value`: Output<String>) {
        this.assessmentId = value
    }

    /**
     * @param value Description of the assessment report.
     */
    @JvmName("gstsipankdciaylg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the assessment report.
     */
    @JvmName("vkdgdpvatovbmhhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Unique identifier of the assessment to create the report from.
     * The following arguments are optional:
     */
    @JvmName("kucqynbeieayylmj")
    public suspend fun assessmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentId = mapped
    }

    /**
     * @param value Description of the assessment report.
     */
    @JvmName("hhvkcqfdfhkkgvbp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the assessment report.
     */
    @JvmName("djmqrikujqeoyylv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AssessmentReportArgs = AssessmentReportArgs(
        assessmentId = assessmentId,
        description = description,
        name = name,
    )
}
