@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AuditmanagerFunctions.getControlPlain
import com.pulumi.aws.auditmanager.AuditmanagerFunctions.getFrameworkPlain
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlControlMappingSource
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlPlainArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlPlainArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkControlSet
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkPlainArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkPlainArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.outputs.GetControlResult
import com.pulumi.aws.auditmanager.kotlin.outputs.GetFrameworkResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.auditmanager.kotlin.outputs.GetControlResult.Companion.toKotlin as getControlResultToKotlin
import com.pulumi.aws.auditmanager.kotlin.outputs.GetFrameworkResult.Companion.toKotlin as getFrameworkResultToKotlin

public object AuditmanagerFunctions {
    /**
     * Data source for managing an AWS Audit Manager Control.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetControlArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("1. Risk Management")
     *             .type("Standard")
     *             .build());
     *     }
     * }
     * ```
     * ### With Framework Resource
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetControlArgs;
     * import com.pulumi.aws.auditmanager.Framework;
     * import com.pulumi.aws.auditmanager.FrameworkArgs;
     * import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleControl = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("1. Risk Management")
     *             .type("Standard")
     *             .build());
     *         final var example2 = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("2. Personnel")
     *             .type("Standard")
     *             .build());
     *         var exampleFramework = new Framework("exampleFramework", FrameworkArgs.builder()
     *             .controlSets(
     *                 FrameworkControlSetArgs.builder()
     *                     .name("example")
     *                     .controls(FrameworkControlSetControlArgs.builder()
     *                         .id(exampleControl.applyValue(getControlResult -> getControlResult.id()))
     *                         .build())
     *                     .build(),
     *                 FrameworkControlSetArgs.builder()
     *                     .name("example2")
     *                     .controls(FrameworkControlSetControlArgs.builder()
     *                         .id(example2.applyValue(getControlResult -> getControlResult.id()))
     *                         .build())
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getControl.
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(argument: GetControlPlainArgs): GetControlResult =
        getControlResultToKotlin(getControlPlain(argument.toJava()).await())

    /**
     * @see [getControl].
     * @param controlMappingSources
     * @param name Name of the control.
     * @param type Type of control. Valid values are `Custom` and `Standard`.
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(
        controlMappingSources: List<GetControlControlMappingSource>? = null,
        name: String,
        type: String,
    ): GetControlResult {
        val argument = GetControlPlainArgs(
            controlMappingSources = controlMappingSources,
            name = name,
            type = type,
        )
        return getControlResultToKotlin(getControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getControl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;auditmanager&#46;kotlin&#46;inputs&#46;GetControlPlainArgs].
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(argument: suspend GetControlPlainArgsBuilder.() -> Unit):
        GetControlResult {
        val builder = GetControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControlResultToKotlin(getControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Audit Manager Framework.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetFrameworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AuditmanagerFunctions.getFramework(GetFrameworkArgs.builder()
     *             .frameworkType("Standard")
     *             .name("Essential Eight")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFramework.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: GetFrameworkPlainArgs): GetFrameworkResult =
        getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())

    /**
     * @see [getFramework].
     * @param controlSets
     * @param frameworkType
     * @param name Name of the framework.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(
        controlSets: List<GetFrameworkControlSet>? = null,
        frameworkType: String,
        name: String,
    ): GetFrameworkResult {
        val argument = GetFrameworkPlainArgs(
            controlSets = controlSets,
            frameworkType = frameworkType,
            name = name,
        )
        return getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getFramework].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;auditmanager&#46;kotlin&#46;inputs&#46;GetFrameworkPlainArgs].
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: suspend GetFrameworkPlainArgsBuilder.() -> Unit):
        GetFrameworkResult {
        val builder = GetFrameworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFrameworkResultToKotlin(getFrameworkPlain(builtArgument.toJava()).await())
    }
}
