@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.kotlin.outputs.ControlControlMappingSource
import com.pulumi.aws.auditmanager.kotlin.outputs.ControlControlMappingSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Control].
 */
@PulumiTagMarker
public class ControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlArgs = ControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlArgsBuilder.() -> Unit) {
        val builder = ControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Control {
        val builtJavaResource = com.pulumi.aws.auditmanager.Control(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Control(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Control.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Control;
 * import com.pulumi.aws.auditmanager.ControlArgs;
 * import com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Control("example", ControlArgs.builder()
 *             .controlMappingSources(ControlControlMappingSourceArgs.builder()
 *                 .sourceName("example")
 *                 .sourceSetUpOption("Procedural_Controls_Mapping")
 *                 .sourceType("MANUAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an Audit Manager Control using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/control:Control example abc123-de45
 * ```
 *
 */
public class Control internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.Control,
) : KotlinCustomResource(javaResource, ControlMapper) {
    /**
     * Recommended actions to carry out if the control isn't fulfilled.
     */
    public val actionPlanInstructions: Output<String>?
        get() = javaResource.actionPlanInstructions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Title of the action plan for remediating the control.
     */
    public val actionPlanTitle: Output<String>?
        get() = javaResource.actionPlanTitle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the control.
     * * `control_mapping_sources.*.source_id` - Unique identifier for the source.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    public val controlMappingSources: Output<List<ControlControlMappingSource>>?
        get() = javaResource.controlMappingSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Description of the control.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the control.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Steps to follow to determine if the control is satisfied.
     */
    public val testingInformation: Output<String>?
        get() = javaResource.testingInformation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of control, such as a custom control or a standard control.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ControlMapper : ResourceMapper<Control> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.Control::class == javaResource::class

    override fun map(javaResource: Resource): Control = Control(
        javaResource as
            com.pulumi.aws.auditmanager.Control,
    )
}

/**
 * @see [Control].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Control].
 */
public suspend fun control(name: String, block: suspend ControlResourceBuilder.() -> Unit):
    Control {
    val builder = ControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Control].
 * @param name The _unique_ name of the resulting resource.
 */
public fun control(name: String): Control {
    val builder = ControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
