@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.ControlArgs.builder
import com.pulumi.aws.auditmanager.kotlin.inputs.ControlControlMappingSourceArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.ControlControlMappingSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Control.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Control;
 * import com.pulumi.aws.auditmanager.ControlArgs;
 * import com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Control("example", ControlArgs.builder()
 *             .controlMappingSources(ControlControlMappingSourceArgs.builder()
 *                 .sourceName("example")
 *                 .sourceSetUpOption("Procedural_Controls_Mapping")
 *                 .sourceType("MANUAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an Audit Manager Control using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/control:Control example abc123-de45
 * ```
 * @property actionPlanInstructions Recommended actions to carry out if the control isn't fulfilled.
 * @property actionPlanTitle Title of the action plan for remediating the control.
 * @property controlMappingSources Data mapping sources. See `control_mapping_sources` below.
 * The following arguments are optional:
 * @property description Description of the control.
 * @property name Name of the control.
 * @property tags A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property testingInformation Steps to follow to determine if the control is satisfied.
 */
public data class ControlArgs(
    public val actionPlanInstructions: Output<String>? = null,
    public val actionPlanTitle: Output<String>? = null,
    public val controlMappingSources: Output<List<ControlControlMappingSourceArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testingInformation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.ControlArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.ControlArgs =
        com.pulumi.aws.auditmanager.ControlArgs.builder()
            .actionPlanInstructions(actionPlanInstructions?.applyValue({ args0 -> args0 }))
            .actionPlanTitle(actionPlanTitle?.applyValue({ args0 -> args0 }))
            .controlMappingSources(
                controlMappingSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testingInformation(testingInformation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlArgs].
 */
@PulumiTagMarker
public class ControlArgsBuilder internal constructor() {
    private var actionPlanInstructions: Output<String>? = null

    private var actionPlanTitle: Output<String>? = null

    private var controlMappingSources: Output<List<ControlControlMappingSourceArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testingInformation: Output<String>? = null

    /**
     * @param value Recommended actions to carry out if the control isn't fulfilled.
     */
    @JvmName("ywyrtygdirgkarjl")
    public suspend fun actionPlanInstructions(`value`: Output<String>) {
        this.actionPlanInstructions = value
    }

    /**
     * @param value Title of the action plan for remediating the control.
     */
    @JvmName("jskeppruruhhhssk")
    public suspend fun actionPlanTitle(`value`: Output<String>) {
        this.actionPlanTitle = value
    }

    /**
     * @param value Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("mvqmqpedcifpoasx")
    public suspend fun controlMappingSources(`value`: Output<List<ControlControlMappingSourceArgs>>) {
        this.controlMappingSources = value
    }

    @JvmName("ufhhexoulpctjfxu")
    public suspend fun controlMappingSources(vararg values: Output<ControlControlMappingSourceArgs>) {
        this.controlMappingSources = Output.all(values.asList())
    }

    /**
     * @param values Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("ahekacwtyphkirgs")
    public suspend fun controlMappingSources(values: List<Output<ControlControlMappingSourceArgs>>) {
        this.controlMappingSources = Output.all(values)
    }

    /**
     * @param value Description of the control.
     */
    @JvmName("kowvejhygmrsvpgk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the control.
     */
    @JvmName("oonitjcelbyvnmdt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sftqxaqadyhjrwhx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Steps to follow to determine if the control is satisfied.
     */
    @JvmName("jqswyeldhsavotsf")
    public suspend fun testingInformation(`value`: Output<String>) {
        this.testingInformation = value
    }

    /**
     * @param value Recommended actions to carry out if the control isn't fulfilled.
     */
    @JvmName("mewybkhrruuhenld")
    public suspend fun actionPlanInstructions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPlanInstructions = mapped
    }

    /**
     * @param value Title of the action plan for remediating the control.
     */
    @JvmName("jbinexmnclfswexv")
    public suspend fun actionPlanTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPlanTitle = mapped
    }

    /**
     * @param value Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("uwsndqdfdyahrraj")
    public suspend fun controlMappingSources(`value`: List<ControlControlMappingSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("mdwtuscoraqcbvuw")
    public suspend
    fun controlMappingSources(argument: List<suspend ControlControlMappingSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ControlControlMappingSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("llqcghufymkfmycm")
    public suspend fun controlMappingSources(
        vararg
        argument: suspend ControlControlMappingSourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ControlControlMappingSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("advbghvipwespkma")
    public suspend
    fun controlMappingSources(argument: suspend ControlControlMappingSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ControlControlMappingSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param values Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("vnulakrrqtgfwdfd")
    public suspend fun controlMappingSources(vararg values: ControlControlMappingSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlMappingSources = mapped
    }

    /**
     * @param value Description of the control.
     */
    @JvmName("rtnkctywxhhfvais")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the control.
     */
    @JvmName("waoyvvxqyfkkifog")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cusypslnasondaow")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jwnxqkdbjuglbpgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Steps to follow to determine if the control is satisfied.
     */
    @JvmName("rbjdswulaaalqgap")
    public suspend fun testingInformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testingInformation = mapped
    }

    internal fun build(): ControlArgs = ControlArgs(
        actionPlanInstructions = actionPlanInstructions,
        actionPlanTitle = actionPlanTitle,
        controlMappingSources = controlMappingSources,
        description = description,
        name = name,
        tags = tags,
        testingInformation = testingInformation,
    )
}
