@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing AWS Audit Manager Organization Admin Account Registration.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration;
 * import com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationAdminAccountRegistration("example", OrganizationAdminAccountRegistrationArgs.builder()
 *             .adminAccountId("012345678901")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Audit Manager Organization Admin Account Registration using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:auditmanager/organizationAdminAccountRegistration:OrganizationAdminAccountRegistration example 012345678901
 * ```
 * @property adminAccountId Identifier for the organization administrator account.
 */
public data class OrganizationAdminAccountRegistrationArgs(
    public val adminAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs =
        com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs.builder()
            .adminAccountId(adminAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationAdminAccountRegistrationArgs].
 */
@PulumiTagMarker
public class OrganizationAdminAccountRegistrationArgsBuilder internal constructor() {
    private var adminAccountId: Output<String>? = null

    /**
     * @param value Identifier for the organization administrator account.
     */
    @JvmName("ybeytobomdyhgwqj")
    public suspend fun adminAccountId(`value`: Output<String>) {
        this.adminAccountId = value
    }

    /**
     * @param value Identifier for the organization administrator account.
     */
    @JvmName("ialxgufrfcxhcbin")
    public suspend fun adminAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminAccountId = mapped
    }

    internal fun build(): OrganizationAdminAccountRegistrationArgs =
        OrganizationAdminAccountRegistrationArgs(
            adminAccountId = adminAccountId,
        )
}
