@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
 * @property destinationType Destination type. Currently, `S3` is the only valid value.
 */
public data class AssessmentAssessmentReportsDestinationArgs(
    public val destination: Output<String>,
    public val destinationType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs> {
    override fun toJava():
        com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs =
        com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 }))
            .destinationType(destinationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentAssessmentReportsDestinationArgs].
 */
@PulumiTagMarker
public class AssessmentAssessmentReportsDestinationArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var destinationType: Output<String>? = null

    /**
     * @param value Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
     */
    @JvmName("gtujameiifmrjkpg")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Destination type. Currently, `S3` is the only valid value.
     */
    @JvmName("afnejixpwpqrtqql")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
     */
    @JvmName("gidfffqnwwjstmna")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Destination type. Currently, `S3` is the only valid value.
     */
    @JvmName("pkyocfdxpdxfivus")
    public suspend fun destinationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    internal fun build(): AssessmentAssessmentReportsDestinationArgs =
        AssessmentAssessmentReportsDestinationArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
            destinationType = destinationType ?: throw PulumiNullFieldException("destinationType"),
        )
}
