@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn Amazon Resource Name (ARN) of the IAM role.
 * @property roleType Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
 */
public data class AssessmentRoleArgs(
    public val roleArn: Output<String>,
    public val roleType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs =
        com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .roleType(roleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentRoleArgs].
 */
@PulumiTagMarker
public class AssessmentRoleArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var roleType: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role.
     */
    @JvmName("stpuptubgrekgwcv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
     */
    @JvmName("cicqsgclnondkbvw")
    public suspend fun roleType(`value`: Output<String>) {
        this.roleType = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role.
     */
    @JvmName("bqwmtepiooomqijo")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
     */
    @JvmName("vrnvltibseigtdtw")
    public suspend fun roleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    internal fun build(): AssessmentRoleArgs = AssessmentRoleArgs(
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        roleType = roleType ?: throw PulumiNullFieldException("roleType"),
    )
}
