@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Identifier for the Amazon Web Services account.
 */
public data class AssessmentScopeAwsAccountArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsAccountArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsAccountArgs =
        com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsAccountArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentScopeAwsAccountArgs].
 */
@PulumiTagMarker
public class AssessmentScopeAwsAccountArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Identifier for the Amazon Web Services account.
     */
    @JvmName("bawwkbuqshdivfxg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Identifier for the Amazon Web Services account.
     */
    @JvmName("pyjylmcurttjgsci")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AssessmentScopeAwsAccountArgs = AssessmentScopeAwsAccountArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
