@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serviceName Name of the Amazon Web Service.
 */
public data class AssessmentScopeAwsServiceArgs(
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsServiceArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsServiceArgs =
        com.pulumi.aws.auditmanager.inputs.AssessmentScopeAwsServiceArgs.builder()
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentScopeAwsServiceArgs].
 */
@PulumiTagMarker
public class AssessmentScopeAwsServiceArgsBuilder internal constructor() {
    private var serviceName: Output<String>? = null

    /**
     * @param value Name of the Amazon Web Service.
     */
    @JvmName("vfivweaqpvymegkm")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of the Amazon Web Service.
     */
    @JvmName("ynhwrqwtlgvfwsat")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): AssessmentScopeAwsServiceArgs = AssessmentScopeAwsServiceArgs(
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
