@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceDescription Description of the source.
 * @property sourceFrequency Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
 * @property sourceId
 * @property sourceKeyword The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
 * @property sourceName Name of the source.
 * @property sourceSetUpOption The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
 * @property sourceType Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.
 * The following arguments are optional:
 * @property troubleshootingText Instructions for troubleshooting the control.
 */
public data class ControlControlMappingSourceArgs(
    public val sourceDescription: Output<String>? = null,
    public val sourceFrequency: Output<String>? = null,
    public val sourceId: Output<String>? = null,
    public val sourceKeyword: Output<ControlControlMappingSourceSourceKeywordArgs>? = null,
    public val sourceName: Output<String>,
    public val sourceSetUpOption: Output<String>,
    public val sourceType: Output<String>,
    public val troubleshootingText: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs =
        com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs.builder()
            .sourceDescription(sourceDescription?.applyValue({ args0 -> args0 }))
            .sourceFrequency(sourceFrequency?.applyValue({ args0 -> args0 }))
            .sourceId(sourceId?.applyValue({ args0 -> args0 }))
            .sourceKeyword(sourceKeyword?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceName(sourceName.applyValue({ args0 -> args0 }))
            .sourceSetUpOption(sourceSetUpOption.applyValue({ args0 -> args0 }))
            .sourceType(sourceType.applyValue({ args0 -> args0 }))
            .troubleshootingText(troubleshootingText?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlControlMappingSourceArgs].
 */
@PulumiTagMarker
public class ControlControlMappingSourceArgsBuilder internal constructor() {
    private var sourceDescription: Output<String>? = null

    private var sourceFrequency: Output<String>? = null

    private var sourceId: Output<String>? = null

    private var sourceKeyword: Output<ControlControlMappingSourceSourceKeywordArgs>? = null

    private var sourceName: Output<String>? = null

    private var sourceSetUpOption: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var troubleshootingText: Output<String>? = null

    /**
     * @param value Description of the source.
     */
    @JvmName("gnnmycrqisbixrts")
    public suspend fun sourceDescription(`value`: Output<String>) {
        this.sourceDescription = value
    }

    /**
     * @param value Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
     */
    @JvmName("iqjdghgbgvnauvit")
    public suspend fun sourceFrequency(`value`: Output<String>) {
        this.sourceFrequency = value
    }

    /**
     * @param value
     */
    @JvmName("hoqdqrbfbgpaxtjx")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
     */
    @JvmName("wrnldxuvtwhgtyvr")
    public suspend fun sourceKeyword(`value`: Output<ControlControlMappingSourceSourceKeywordArgs>) {
        this.sourceKeyword = value
    }

    /**
     * @param value Name of the source.
     */
    @JvmName("lwgwkhypdpbsjgcn")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
     */
    @JvmName("qyrfumivhtwwrngs")
    public suspend fun sourceSetUpOption(`value`: Output<String>) {
        this.sourceSetUpOption = value
    }

    /**
     * @param value Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.
     * The following arguments are optional:
     */
    @JvmName("hyslotvotjxuhgki")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value Instructions for troubleshooting the control.
     */
    @JvmName("cycgoekmwhgykfkl")
    public suspend fun troubleshootingText(`value`: Output<String>) {
        this.troubleshootingText = value
    }

    /**
     * @param value Description of the source.
     */
    @JvmName("cagnggemlefdbwyx")
    public suspend fun sourceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDescription = mapped
    }

    /**
     * @param value Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
     */
    @JvmName("vjtsxrkivgvtehmr")
    public suspend fun sourceFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFrequency = mapped
    }

    /**
     * @param value
     */
    @JvmName("fwaeemumfoxhyxuf")
    public suspend fun sourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    /**
     * @param value The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
     */
    @JvmName("fatqodvlmnkdydvp")
    public suspend fun sourceKeyword(`value`: ControlControlMappingSourceSourceKeywordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceKeyword = mapped
    }

    /**
     * @param argument The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
     */
    @JvmName("aaujpkggkwtfynst")
    public suspend
    fun sourceKeyword(argument: suspend ControlControlMappingSourceSourceKeywordArgsBuilder.() -> Unit) {
        val toBeMapped = ControlControlMappingSourceSourceKeywordArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceKeyword = mapped
    }

    /**
     * @param value Name of the source.
     */
    @JvmName("okolehnydwnusrtk")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
     */
    @JvmName("jupkndxcfhmwgfij")
    public suspend fun sourceSetUpOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSetUpOption = mapped
    }

    /**
     * @param value Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.
     * The following arguments are optional:
     */
    @JvmName("djtfexdrvmdputne")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Instructions for troubleshooting the control.
     */
    @JvmName("jxngtnohtuendwdl")
    public suspend fun troubleshootingText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.troubleshootingText = mapped
    }

    internal fun build(): ControlControlMappingSourceArgs = ControlControlMappingSourceArgs(
        sourceDescription = sourceDescription,
        sourceFrequency = sourceFrequency,
        sourceId = sourceId,
        sourceKeyword = sourceKeyword,
        sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
        sourceSetUpOption = sourceSetUpOption ?: throw PulumiNullFieldException("sourceSetUpOption"),
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
        troubleshootingText = troubleshootingText,
    )
}
