@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceSourceKeywordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keywordInputType Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
 * @property keywordValue The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
 */
public data class ControlControlMappingSourceSourceKeywordArgs(
    public val keywordInputType: Output<String>,
    public val keywordValue: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceSourceKeywordArgs> {
    override fun toJava():
        com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceSourceKeywordArgs =
        com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceSourceKeywordArgs.builder()
            .keywordInputType(keywordInputType.applyValue({ args0 -> args0 }))
            .keywordValue(keywordValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlControlMappingSourceSourceKeywordArgs].
 */
@PulumiTagMarker
public class ControlControlMappingSourceSourceKeywordArgsBuilder internal constructor() {
    private var keywordInputType: Output<String>? = null

    private var keywordValue: Output<String>? = null

    /**
     * @param value Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
     */
    @JvmName("kvbrsiqsohyrpqgo")
    public suspend fun keywordInputType(`value`: Output<String>) {
        this.keywordInputType = value
    }

    /**
     * @param value The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
     */
    @JvmName("ppvdsctwioslcint")
    public suspend fun keywordValue(`value`: Output<String>) {
        this.keywordValue = value
    }

    /**
     * @param value Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
     */
    @JvmName("njefvqpgahysjocg")
    public suspend fun keywordInputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywordInputType = mapped
    }

    /**
     * @param value The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
     */
    @JvmName("gbboioovisnsmheq")
    public suspend fun keywordValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywordValue = mapped
    }

    internal fun build(): ControlControlMappingSourceSourceKeywordArgs =
        ControlControlMappingSourceSourceKeywordArgs(
            keywordInputType = keywordInputType ?: throw PulumiNullFieldException("keywordInputType"),
            keywordValue = keywordValue ?: throw PulumiNullFieldException("keywordValue"),
        )
}
