@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property controls List of controls within the control set. See `controls` below.
 * @property id Unique identifier of the control.
 * @property name Name of the control set.
 */
public data class FrameworkControlSetArgs(
    public val controls: Output<List<FrameworkControlSetControlArgs>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs =
        com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs.builder()
            .controls(
                controls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrameworkControlSetArgs].
 */
@PulumiTagMarker
public class FrameworkControlSetArgsBuilder internal constructor() {
    private var controls: Output<List<FrameworkControlSetControlArgs>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value List of controls within the control set. See `controls` below.
     */
    @JvmName("mhqafedgrvkmwmhh")
    public suspend fun controls(`value`: Output<List<FrameworkControlSetControlArgs>>) {
        this.controls = value
    }

    @JvmName("iynpprldwxooikyu")
    public suspend fun controls(vararg values: Output<FrameworkControlSetControlArgs>) {
        this.controls = Output.all(values.asList())
    }

    /**
     * @param values List of controls within the control set. See `controls` below.
     */
    @JvmName("jgpyddmvpbuyqeqs")
    public suspend fun controls(values: List<Output<FrameworkControlSetControlArgs>>) {
        this.controls = Output.all(values)
    }

    /**
     * @param value Unique identifier of the control.
     */
    @JvmName("jhqgbsuviuynnmnu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the control set.
     */
    @JvmName("nkcgeujujleomxqo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of controls within the control set. See `controls` below.
     */
    @JvmName("sdcxkaulmwuuqkbb")
    public suspend fun controls(`value`: List<FrameworkControlSetControlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param argument List of controls within the control set. See `controls` below.
     */
    @JvmName("cnpxdrxxknurvxsv")
    public suspend
    fun controls(argument: List<suspend FrameworkControlSetControlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrameworkControlSetControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument List of controls within the control set. See `controls` below.
     */
    @JvmName("ucdxyviixrmjhmmf")
    public suspend fun controls(
        vararg
        argument: suspend FrameworkControlSetControlArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrameworkControlSetControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument List of controls within the control set. See `controls` below.
     */
    @JvmName("chinlrwdfosanvve")
    public suspend fun controls(argument: suspend FrameworkControlSetControlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrameworkControlSetControlArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param values List of controls within the control set. See `controls` below.
     */
    @JvmName("nupmtxljqarveoxx")
    public suspend fun controls(vararg values: FrameworkControlSetControlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param value Unique identifier of the control.
     */
    @JvmName("dxjkweubvysrqydm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the control set.
     */
    @JvmName("lheayseplcmhqhtc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): FrameworkControlSetArgs = FrameworkControlSetArgs(
        controls = controls,
        id = id,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
