@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Unique identifier of the control.
 */
public data class FrameworkControlSetControlArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.FrameworkControlSetControlArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.FrameworkControlSetControlArgs =
        com.pulumi.aws.auditmanager.inputs.FrameworkControlSetControlArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrameworkControlSetControlArgs].
 */
@PulumiTagMarker
public class FrameworkControlSetControlArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Unique identifier of the control.
     */
    @JvmName("hkgyxhbacjbqksxh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Unique identifier of the control.
     */
    @JvmName("cvuykdktqmvpiipq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): FrameworkControlSetControlArgs = FrameworkControlSetControlArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
