@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSource.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceDescription
 * @property sourceFrequency
 * @property sourceId
 * @property sourceKeyword
 * @property sourceName
 * @property sourceSetUpOption
 * @property sourceType
 * @property troubleshootingText
 */
public data class GetControlControlMappingSource(
    public val sourceDescription: String,
    public val sourceFrequency: String,
    public val sourceId: String,
    public val sourceKeyword: GetControlControlMappingSourceSourceKeyword? = null,
    public val sourceName: String,
    public val sourceSetUpOption: String,
    public val sourceType: String,
    public val troubleshootingText: String,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSource> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSource =
        com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSource.builder()
            .sourceDescription(sourceDescription.let({ args0 -> args0 }))
            .sourceFrequency(sourceFrequency.let({ args0 -> args0 }))
            .sourceId(sourceId.let({ args0 -> args0 }))
            .sourceKeyword(sourceKeyword?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceName(sourceName.let({ args0 -> args0 }))
            .sourceSetUpOption(sourceSetUpOption.let({ args0 -> args0 }))
            .sourceType(sourceType.let({ args0 -> args0 }))
            .troubleshootingText(troubleshootingText.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlControlMappingSource].
 */
@PulumiTagMarker
public class GetControlControlMappingSourceBuilder internal constructor() {
    private var sourceDescription: String? = null

    private var sourceFrequency: String? = null

    private var sourceId: String? = null

    private var sourceKeyword: GetControlControlMappingSourceSourceKeyword? = null

    private var sourceName: String? = null

    private var sourceSetUpOption: String? = null

    private var sourceType: String? = null

    private var troubleshootingText: String? = null

    /**
     * @param value
     */
    @JvmName("aclmmfbgeijsaiev")
    public suspend fun sourceDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceDescription = mapped
    }

    /**
     * @param value
     */
    @JvmName("lkldhkccrkikknix")
    public suspend fun sourceFrequency(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceFrequency = mapped
    }

    /**
     * @param value
     */
    @JvmName("datxxavhficaacoa")
    public suspend fun sourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ubabuogifxiwrlhv")
    public suspend fun sourceKeyword(`value`: GetControlControlMappingSourceSourceKeyword?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceKeyword = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ccvkrlxbuvrwdoqt")
    public suspend
    fun sourceKeyword(argument: suspend GetControlControlMappingSourceSourceKeywordBuilder.() -> Unit) {
        val toBeMapped = GetControlControlMappingSourceSourceKeywordBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.sourceKeyword = mapped
    }

    /**
     * @param value
     */
    @JvmName("bdtbfyaevbxtfhhf")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvfcvojgykarcdfc")
    public suspend fun sourceSetUpOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceSetUpOption = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmdvwduaunjefikw")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwacsffdfnjbrtuu")
    public suspend fun troubleshootingText(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.troubleshootingText = mapped
    }

    internal fun build(): GetControlControlMappingSource = GetControlControlMappingSource(
        sourceDescription = sourceDescription ?: throw PulumiNullFieldException("sourceDescription"),
        sourceFrequency = sourceFrequency ?: throw PulumiNullFieldException("sourceFrequency"),
        sourceId = sourceId ?: throw PulumiNullFieldException("sourceId"),
        sourceKeyword = sourceKeyword,
        sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
        sourceSetUpOption = sourceSetUpOption ?: throw PulumiNullFieldException("sourceSetUpOption"),
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
        troubleshootingText = troubleshootingText ?: throw PulumiNullFieldException("troubleshootingText"),
    )
}
