@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSourceSourceKeyword.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keywordInputType
 * @property keywordValue
 */
public data class GetControlControlMappingSourceSourceKeyword(
    public val keywordInputType: String,
    public val keywordValue: String,
) :
    ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSourceSourceKeyword> {
    override fun toJava():
        com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSourceSourceKeyword =
        com.pulumi.aws.auditmanager.inputs.GetControlControlMappingSourceSourceKeyword.builder()
            .keywordInputType(keywordInputType.let({ args0 -> args0 }))
            .keywordValue(keywordValue.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlControlMappingSourceSourceKeyword].
 */
@PulumiTagMarker
public class GetControlControlMappingSourceSourceKeywordBuilder internal constructor() {
    private var keywordInputType: String? = null

    private var keywordValue: String? = null

    /**
     * @param value
     */
    @JvmName("kkcfvpmtfbvakxkr")
    public suspend fun keywordInputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keywordInputType = mapped
    }

    /**
     * @param value
     */
    @JvmName("uyeyoinkgteuxtsg")
    public suspend fun keywordValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keywordValue = mapped
    }

    internal fun build(): GetControlControlMappingSourceSourceKeyword =
        GetControlControlMappingSourceSourceKeyword(
            keywordInputType = keywordInputType ?: throw PulumiNullFieldException("keywordInputType"),
            keywordValue = keywordValue ?: throw PulumiNullFieldException("keywordValue"),
        )
}
