@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.GetControlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getControl.
 * @property controlMappingSources
 * @property name Name of the control.
 * @property type Type of control. Valid values are `Custom` and `Standard`.
 */
public data class GetControlPlainArgs(
    public val controlMappingSources: List<GetControlControlMappingSource>? = null,
    public val name: String,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.GetControlPlainArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.GetControlPlainArgs =
        com.pulumi.aws.auditmanager.inputs.GetControlPlainArgs.builder()
            .controlMappingSources(
                controlMappingSources?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlPlainArgs].
 */
@PulumiTagMarker
public class GetControlPlainArgsBuilder internal constructor() {
    private var controlMappingSources: List<GetControlControlMappingSource>? = null

    private var name: String? = null

    private var type: String? = null

    /**
     * @param value
     */
    @JvmName("qfakmxblaxbliwqa")
    public suspend fun controlMappingSources(`value`: List<GetControlControlMappingSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.controlMappingSources = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uiltsqmsuemqiaeh")
    public suspend
    fun controlMappingSources(argument: List<suspend GetControlControlMappingSourceBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetControlControlMappingSourceBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controlMappingSources = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tcwscbgsvkrmtngc")
    public suspend fun controlMappingSources(
        vararg
        argument: suspend GetControlControlMappingSourceBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetControlControlMappingSourceBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controlMappingSources = mapped
    }

    /**
     * @param argument
     */
    @JvmName("alxjjaxvkjyxkksj")
    public suspend
    fun controlMappingSources(argument: suspend GetControlControlMappingSourceBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetControlControlMappingSourceBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.controlMappingSources = mapped
    }

    /**
     * @param values
     */
    @JvmName("oqtgsxijthyyhwwd")
    public suspend fun controlMappingSources(vararg values: GetControlControlMappingSource) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.controlMappingSources = mapped
    }

    /**
     * @param value Name of the control.
     */
    @JvmName("cajuegoxcivdssvm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Type of control. Valid values are `Custom` and `Standard`.
     */
    @JvmName("yrfsxryclfeniueu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetControlPlainArgs = GetControlPlainArgs(
        controlMappingSources = controlMappingSources,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
