@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.GetFrameworkControlSet.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property controls
 * @property id
 * @property name Name of the framework.
 */
public data class GetFrameworkControlSet(
    public val controls: List<GetFrameworkControlSetControl>? = null,
    public val id: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.GetFrameworkControlSet> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.GetFrameworkControlSet =
        com.pulumi.aws.auditmanager.inputs.GetFrameworkControlSet.builder()
            .controls(controls?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFrameworkControlSet].
 */
@PulumiTagMarker
public class GetFrameworkControlSetBuilder internal constructor() {
    private var controls: List<GetFrameworkControlSetControl>? = null

    private var id: String? = null

    private var name: String? = null

    /**
     * @param value
     */
    @JvmName("mpmeomjsfhvgculs")
    public suspend fun controls(`value`: List<GetFrameworkControlSetControl>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.controls = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gjhhkjmsoorksoun")
    public suspend
    fun controls(argument: List<suspend GetFrameworkControlSetControlBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetFrameworkControlSetControlBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controls = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pccmtpyaymfofsos")
    public suspend fun controls(
        vararg
        argument: suspend GetFrameworkControlSetControlBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetFrameworkControlSetControlBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controls = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bsgpmrqtpsjlcuul")
    public suspend fun controls(argument: suspend GetFrameworkControlSetControlBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetFrameworkControlSetControlBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.controls = mapped
    }

    /**
     * @param values
     */
    @JvmName("nmyhyhfmkqaywwef")
    public suspend fun controls(vararg values: GetFrameworkControlSetControl) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.controls = mapped
    }

    /**
     * @param value
     */
    @JvmName("uirrpgmovddsqsfo")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the framework.
     */
    @JvmName("rfvoiuwqludsjjee")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetFrameworkControlSet = GetFrameworkControlSet(
        controls = controls,
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
