@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property awsAccounts Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
 * @property awsServices Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
 */
public data class AssessmentScope(
    public val awsAccounts: List<AssessmentScopeAwsAccount>? = null,
    public val awsServices: List<AssessmentScopeAwsService>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.AssessmentScope):
            AssessmentScope = AssessmentScope(
            awsAccounts = javaType.awsAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentScopeAwsAccount.Companion.toKotlin(args0)
                })
            }),
            awsServices = javaType.awsServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.AssessmentScopeAwsService.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
