@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keywordInputType Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
 * @property keywordValue The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
 */
public data class ControlControlMappingSourceSourceKeyword(
    public val keywordInputType: String,
    public val keywordValue: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.ControlControlMappingSourceSourceKeyword):
            ControlControlMappingSourceSourceKeyword = ControlControlMappingSourceSourceKeyword(
            keywordInputType = javaType.keywordInputType(),
            keywordValue = javaType.keywordValue(),
        )
    }
}
