@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property controls List of controls within the control set. See `controls` below.
 * @property id Unique identifier of the control.
 * @property name Name of the control set.
 */
public data class FrameworkControlSet(
    public val controls: List<FrameworkControlSetControl>? = null,
    public val id: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.FrameworkControlSet):
            FrameworkControlSet = FrameworkControlSet(
            controls = javaType.controls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.FrameworkControlSetControl.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
