@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFramework.
 * @property arn
 * @property complianceType
 * @property controlSets
 * @property description
 * @property frameworkType
 * @property id
 * @property name
 * @property tags
 */
public data class GetFrameworkResult(
    public val arn: String,
    public val complianceType: String,
    public val controlSets: List<GetFrameworkControlSet>? = null,
    public val description: String,
    public val frameworkType: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.GetFrameworkResult):
            GetFrameworkResult = GetFrameworkResult(
            arn = javaType.arn(),
            complianceType = javaType.complianceType(),
            controlSets = javaType.controlSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.GetFrameworkControlSet.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            frameworkType = javaType.frameworkType(),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
