@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.AttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a load balancer to an Auto Scaling group.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Attachment;
 * import com.pulumi.aws.autoscaling.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Attachment("example", AttachmentArgs.builder()
 *             .autoscalingGroupName(aws_autoscaling_group.example().id())
 *             .elb(aws_elb.example().id())
 *             .build());
 *     }
 * }
 * ```
 * @property autoscalingGroupName Name of ASG to associate with the ELB.
 * @property elb Name of the ELB.
 * @property lbTargetGroupArn ARN of a load balancer target group.
 */
public data class AttachmentArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val elb: Output<String>? = null,
    public val lbTargetGroupArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.AttachmentArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.AttachmentArgs =
        com.pulumi.aws.autoscaling.AttachmentArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .elb(elb?.applyValue({ args0 -> args0 }))
            .lbTargetGroupArn(lbTargetGroupArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentArgs].
 */
@PulumiTagMarker
public class AttachmentArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var elb: Output<String>? = null

    private var lbTargetGroupArn: Output<String>? = null

    /**
     * @param value Name of ASG to associate with the ELB.
     */
    @JvmName("tfkmrprhxmqycyft")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value Name of the ELB.
     */
    @JvmName("fwpabntywalbvpuc")
    public suspend fun elb(`value`: Output<String>) {
        this.elb = value
    }

    /**
     * @param value ARN of a load balancer target group.
     */
    @JvmName("dmiwjjjqsflcvggj")
    public suspend fun lbTargetGroupArn(`value`: Output<String>) {
        this.lbTargetGroupArn = value
    }

    /**
     * @param value Name of ASG to associate with the ELB.
     */
    @JvmName("wawpipgdgnytnrxm")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value Name of the ELB.
     */
    @JvmName("sbodtqliitxwnihe")
    public suspend fun elb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elb = mapped
    }

    /**
     * @param value ARN of a load balancer target group.
     */
    @JvmName("otocxwlttqnxvxdp")
    public suspend fun lbTargetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbTargetGroupArn = mapped
    }

    internal fun build(): AttachmentArgs = AttachmentArgs(
        autoscalingGroupName = autoscalingGroupName,
        elb = elb,
        lbTargetGroupArn = lbTargetGroupArn,
    )
}
