@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInitialLifecycleHook
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInstanceMaintenancePolicy
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInstanceRefresh
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupLaunchTemplate
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicy
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupTag
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupTrafficSource
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupWarmPool
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInitialLifecycleHook.Companion.toKotlin as groupInitialLifecycleHookToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInstanceMaintenancePolicy.Companion.toKotlin as groupInstanceMaintenancePolicyToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupInstanceRefresh.Companion.toKotlin as groupInstanceRefreshToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupLaunchTemplate.Companion.toKotlin as groupLaunchTemplateToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicy.Companion.toKotlin as groupMixedInstancesPolicyToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupTag.Companion.toKotlin as groupTagToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupTrafficSource.Companion.toKotlin as groupTrafficSourceToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GroupWarmPool.Companion.toKotlin as groupWarmPoolToKotlin

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.aws.autoscaling.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * Provides an Auto Scaling Group resource.
 * > **Note:** You must specify either `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new PlacementGroup("test", PlacementGroupArgs.builder()
 *             .strategy("cluster")
 *             .build());
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .maxSize(5)
 *             .minSize(2)
 *             .healthCheckGracePeriod(300)
 *             .healthCheckType("ELB")
 *             .desiredCapacity(4)
 *             .forceDelete(true)
 *             .placementGroup(test.id())
 *             .launchConfiguration(aws_launch_configuration.foobar().name())
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .instanceMaintenancePolicy(GroupInstanceMaintenancePolicyArgs.builder()
 *                 .minHealthyPercentage(90)
 *                 .maxHealthyPercentage(120)
 *                 .build())
 *             .initialLifecycleHooks(GroupInitialLifecycleHookArgs.builder()
 *                 .name("foobar")
 *                 .defaultResult("CONTINUE")
 *                 .heartbeatTimeout(2000)
 *                 .lifecycleTransition("autoscaling:EC2_INSTANCE_LAUNCHING")
 *                 .notificationMetadata(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("foo", "bar")
 *                     )))
 *                 .notificationTargetArn("arn:aws:sqs:us-east-1:444455556666:queue1*")
 *                 .roleArn("arn:aws:iam::123456789012:role/S3Access")
 *                 .build())
 *             .tags(
 *                 GroupTagArgs.builder()
 *                     .key("foo")
 *                     .value("bar")
 *                     .propagateAtLaunch(true)
 *                     .build(),
 *                 GroupTagArgs.builder()
 *                     .key("lorem")
 *                     .value("ipsum")
 *                     .propagateAtLaunch(false)
 *                     .build())
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### With Latest Version Of Launch Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new LaunchTemplate("foobar", LaunchTemplateArgs.builder()
 *             .namePrefix("foobar")
 *             .imageId("ami-1a2b3c")
 *             .instanceType("t2.micro")
 *             .build());
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .launchTemplate(GroupLaunchTemplateArgs.builder()
 *                 .id(foobar.id())
 *                 .version("$Latest")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c3.large")
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Spot Instances and Capacity Rebalance
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .capacityRebalance(true)
 *             .desiredCapacity(12)
 *             .maxSize(15)
 *             .minSize(12)
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .instancesDistribution(GroupMixedInstancesPolicyInstancesDistributionArgs.builder()
 *                     .onDemandBaseCapacity(0)
 *                     .onDemandPercentageAboveBaseCapacity(25)
 *                     .spotAllocationStrategy("capacity-optimized")
 *                     .build())
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c3.large")
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Instance level LaunchTemplateSpecification Overrides
 * When using a diverse instance set, some instance types might require a launch template with configuration values unique to that instance type such as a different AMI (Graviton2), architecture specific user data script, different EBS configuration, or different networking configuration.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var example2 = new LaunchTemplate("example2", LaunchTemplateArgs.builder()
 *             .namePrefix("example2")
 *             .imageId(data.aws_ami().example2().id())
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c6g.large")
 *                             .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs.builder()
 *                                 .launchTemplateId(example2.id())
 *                                 .build())
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Attribute-based Instance Type Selection
 * As an alternative to manually choosing instance types when creating a mixed instances group, you can specify a set of instance attributes that describe your compute requirements.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                         .instanceRequirements(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs.builder()
 *                             .memoryMib(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs.builder()
 *                                 .min(1000)
 *                                 .build())
 *                             .vcpuCount(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs.builder()
 *                                 .min(4)
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Dynamic tagging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var extraTags = config.get("extraTags").orElse(
 *             %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *             %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference));
 *         var test = new Group("test", GroupArgs.builder()
 *             .maxSize(5)
 *             .minSize(2)
 *             .launchConfiguration(aws_launch_configuration.foobar().name())
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .tags(
 *                 GroupTagArgs.builder()
 *                     .key("explicit1")
 *                     .value("value1")
 *                     .propagateAtLaunch(true)
 *                     .build(),
 *                 GroupTagArgs.builder()
 *                     .key("explicit2")
 *                     .value("value2")
 *                     .propagateAtLaunch(true)
 *                     .build())
 *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### Automatically refresh all instances after the group is updated
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleAmi = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("amzn-ami-hvm-*-x86_64-gp2")
 *                 .build())
 *             .build());
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId(exampleAmi.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t3.nano")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(2)
 *             .minSize(1)
 *             .launchTemplate(GroupLaunchTemplateArgs.builder()
 *                 .id(exampleLaunchTemplate.id())
 *                 .version(exampleLaunchTemplate.latestVersion())
 *                 .build())
 *             .tags(GroupTagArgs.builder()
 *                 .key("Key")
 *                 .value("Value")
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .instanceRefresh(GroupInstanceRefreshArgs.builder()
 *                 .strategy("Rolling")
 *                 .preferences(GroupInstanceRefreshPreferencesArgs.builder()
 *                     .minHealthyPercentage(50)
 *                     .build())
 *                 .triggers("tag")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Scaling group with Warm Pool
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(5)
 *             .minSize(1)
 *             .warmPool(GroupWarmPoolArgs.builder()
 *                 .poolState("Hibernated")
 *                 .minSize(1)
 *                 .maxGroupPreparedCapacity(10)
 *                 .instanceReusePolicy(GroupWarmPoolInstanceReusePolicyArgs.builder()
 *                     .reuseOnScaleIn(true)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Scaling group with Traffic Sources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Group("test", GroupArgs.builder()
 *             .vpcZoneIdentifiers(aws_subnet.test().id())
 *             .maxSize(1)
 *             .minSize(1)
 *             .forceDelete(true)
 *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Waiting for Capacity
 * A newly-created ASG is initially empty and begins to scale to `min_size` (or
 * `desired_capacity`, if specified) by launching instances using the provided
 * Launch Configuration. These instances take time to launch and boot.
 * On ASG Update, changes to these values also take time to result in the target
 * number of instances providing service.
 * This provider provides two mechanisms to help consistently manage ASG scale up
 * time across dependent resources.
 * #### Waiting for ASG Capacity
 * The first is default behavior. This provider waits after ASG creation for
 * `min_size` (or `desired_capacity`, if specified) healthy instances to show up
 * in the ASG before continuing.
 * If `min_size` or `desired_capacity` are changed in a subsequent update,
 * this provider will also wait for the correct number of healthy instances before
 * continuing.
 * This provider considers an instance "healthy" when the ASG reports `HealthStatus:
 * "Healthy"` and `LifecycleState: "InService"`. See the [AWS AutoScaling
 * Docs](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
 * for more information on an ASG's lifecycle.
 * This provider will wait for healthy instances for up to
 * `wait_for_capacity_timeout`. If ASG creation is taking more than a few minutes,
 * it's worth investigating for scaling activity errors, which can be caused by
 * problems with the selected Launch Configuration.
 * Setting `wait_for_capacity_timeout` to `"0"` disables ASG Capacity waiting.
 * #### Waiting for ELB Capacity
 * The second mechanism is optional, and affects ASGs with attached ELBs specified
 * via the `load_balancers` attribute or with ALBs specified with `target_group_arns`.
 * The `min_elb_capacity` parameter causes the provider to wait for at least the
 * requested number of instances to show up `"InService"` in all attached ELBs
 * during ASG creation. It has no effect on ASG updates.
 * If `wait_for_elb_capacity` is set, the provider will wait for exactly that number
 * of Instances to be `"InService"` in all attached ELBs on both creation and
 * updates.
 * These parameters can be used to ensure that service is being provided before
 * the provider moves on. If new instances don't pass the ELB's health checks for any
 * reason, the apply will time out, and the ASG will be marked as
 * tainted (i.e., marked to be destroyed in a follow up run).
 * As with ASG Capacity, the provider will wait for up to `wait_for_capacity_timeout`
 * for the proper number of instances to be healthy.
 * #### Troubleshooting Capacity Waiting Timeouts
 * If ASG creation takes more than a few minutes, this could indicate one of a
 * number of configuration problems. See the [AWS Docs on Load Balancer
 * Troubleshooting](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-troubleshooting.html)
 * for more information.
 * ## Import
 * Using `pulumi import`, import Auto Scaling Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/group:Group web web-asg
 * ```
 *
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * ARN for this Auto Scaling Group
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
     */
    public val capacityRebalance: Output<Boolean>?
        get() = javaResource.capacityRebalance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reserved.
     */
    public val context: Output<String>?
        get() = javaResource.context().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     */
    public val defaultCooldown: Output<Int>
        get() = javaResource.defaultCooldown().applyValue({ args0 -> args0 })

    /**
     * Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
     */
    public val defaultInstanceWarmup: Output<Int>?
        get() = javaResource.defaultInstanceWarmup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of Amazon EC2 instances that
     * should be running in the group. (See also Waiting for
     * Capacity below.)
     */
    public val desiredCapacity: Output<Int>
        get() = javaResource.desiredCapacity().applyValue({ args0 -> args0 })

    /**
     * The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
     */
    public val desiredCapacityType: Output<String>?
        get() = javaResource.desiredCapacityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     */
    public val enabledMetrics: Output<List<String>>?
        get() = javaResource.enabledMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Allows deleting the Auto Scaling Group without waiting
     * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
     * even if it's in the process of scaling a resource. Normally, this provider
     * drains all the instances before deleting the group. This bypasses that
     * behavior and potentially leaves resources dangling.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
     */
    public val forceDeleteWarmPool: Output<Boolean>?
        get() = javaResource.forceDeleteWarmPool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time (in seconds) after instance comes into service before checking health.
     */
    public val healthCheckGracePeriod: Output<Int>?
        get() = javaResource.healthCheckGracePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * "EC2" or "ELB". Controls how health checking is done.
     */
    public val healthCheckType: Output<String>
        get() = javaResource.healthCheckType().applyValue({ args0 -> args0 })

    /**
     * Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
     */
    public val ignoreFailedScalingActivities: Output<Boolean>?
        get() = javaResource.ignoreFailedScalingActivities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    public val initialLifecycleHooks: Output<List<GroupInitialLifecycleHook>>?
        get() = javaResource.initialLifecycleHooks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        groupInitialLifecycleHookToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
     */
    public val instanceMaintenancePolicy: Output<GroupInstanceMaintenancePolicy>?
        get() = javaResource.instanceMaintenancePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> groupInstanceMaintenancePolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     */
    public val instanceRefresh: Output<GroupInstanceRefresh>?
        get() = javaResource.instanceRefresh().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> groupInstanceRefreshToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the launch configuration to use.
     */
    public val launchConfiguration: Output<String>?
        get() = javaResource.launchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     */
    public val launchTemplate: Output<GroupLaunchTemplate>
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.let({ args0 ->
                groupLaunchTemplateToKotlin(args0)
            })
        })

    /**
     * List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     */
    public val loadBalancers: Output<List<String>>
        get() = javaResource.loadBalancers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
     */
    public val maxInstanceLifetime: Output<Int>?
        get() = javaResource.maxInstanceLifetime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum size of the Auto Scaling Group.
     */
    public val maxSize: Output<Int>
        get() = javaResource.maxSize().applyValue({ args0 -> args0 })

    /**
     * Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     */
    public val metricsGranularity: Output<String>?
        get() = javaResource.metricsGranularity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting this causes Pulumi to wait for
     * this number of instances from this Auto Scaling Group to show up healthy in the
     * ELB only on creation. Updates will not wait on ELB instance number changes.
     * (See also Waiting for Capacity below.)
     */
    public val minElbCapacity: Output<Int>?
        get() = javaResource.minElbCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum size of the Auto Scaling Group.
     * (See also Waiting for Capacity below.)
     */
    public val minSize: Output<Int>
        get() = javaResource.minSize().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     */
    public val mixedInstancesPolicy: Output<GroupMixedInstancesPolicy>
        get() = javaResource.mixedInstancesPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                groupMixedInstancesPolicyToKotlin(args0)
            })
        })

    /**
     * Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Name of the placement group into which you'll launch your instances, if any.
     */
    public val placementGroup: Output<String>?
        get() = javaResource.placementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Predicted capacity of the group.
     */
    public val predictedCapacity: Output<Int>
        get() = javaResource.predictedCapacity().applyValue({ args0 -> args0 })

    /**
     * Whether newly launched instances
     * are automatically protected from termination by Amazon EC2 Auto Scaling when
     * scaling in. For more information about preventing instances from terminating
     * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
     * in the Amazon EC2 Auto Scaling User Guide.
     */
    public val protectFromScaleIn: Output<Boolean>?
        get() = javaResource.protectFromScaleIn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the service-linked role that the ASG will use to call other AWS services
     */
    public val serviceLinkedRoleArn: Output<String>
        get() = javaResource.serviceLinkedRoleArn().applyValue({ args0 -> args0 })

    /**
     * List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     */
    public val suspendedProcesses: Output<List<String>>?
        get() = javaResource.suspendedProcesses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration block(s) containing resource tags. See Tag below for more details.
     */
    public val tags: Output<List<GroupTag>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> groupTagToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     */
    public val targetGroupArns: Output<List<String>>
        get() = javaResource.targetGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     */
    public val terminationPolicies: Output<List<String>>?
        get() = javaResource.terminationPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    public val trafficSources: Output<List<GroupTrafficSource>>
        get() = javaResource.trafficSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> groupTrafficSourceToKotlin(args0) })
            })
        })

    /**
     * List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     */
    public val vpcZoneIdentifiers: Output<List<String>>
        get() = javaResource.vpcZoneIdentifiers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
     * wait for ASG instances to be healthy before timing out. (See also Waiting
     * for Capacity below.) Setting this to "0" causes
     * the provider to skip all Capacity Waiting behavior.
     */
    public val waitForCapacityTimeout: Output<String>?
        get() = javaResource.waitForCapacityTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting this will cause Pulumi to wait
     * for exactly this number of healthy instances from this Auto Scaling Group in
     * all attached load balancers on both create and update operations. (Takes
     * precedence over `min_elb_capacity` behavior.)
     * (See also Waiting for Capacity below.)
     */
    public val waitForElbCapacity: Output<Int>?
        get() = javaResource.waitForElbCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     */
    public val warmPool: Output<GroupWarmPool>?
        get() = javaResource.warmPool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    groupWarmPoolToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Current size of the warm pool.
     */
    public val warmPoolSize: Output<Int>
        get() = javaResource.warmPoolSize().applyValue({ args0 -> args0 })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(
        javaResource as
            com.pulumi.aws.autoscaling.Group,
    )
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
