@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.GroupArgs.builder
import com.pulumi.aws.autoscaling.kotlin.enums.MetricsGranularity
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInitialLifecycleHookArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInitialLifecycleHookArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInstanceMaintenancePolicyArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInstanceMaintenancePolicyArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInstanceRefreshArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupInstanceRefreshArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupLaunchTemplateArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupLaunchTemplateArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupMixedInstancesPolicyArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupMixedInstancesPolicyArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupTagArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupTagArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupTrafficSourceArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupTrafficSourceArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupWarmPoolArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GroupWarmPoolArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Auto Scaling Group resource.
 * > **Note:** You must specify either `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new PlacementGroup("test", PlacementGroupArgs.builder()
 *             .strategy("cluster")
 *             .build());
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .maxSize(5)
 *             .minSize(2)
 *             .healthCheckGracePeriod(300)
 *             .healthCheckType("ELB")
 *             .desiredCapacity(4)
 *             .forceDelete(true)
 *             .placementGroup(test.id())
 *             .launchConfiguration(aws_launch_configuration.foobar().name())
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .instanceMaintenancePolicy(GroupInstanceMaintenancePolicyArgs.builder()
 *                 .minHealthyPercentage(90)
 *                 .maxHealthyPercentage(120)
 *                 .build())
 *             .initialLifecycleHooks(GroupInitialLifecycleHookArgs.builder()
 *                 .name("foobar")
 *                 .defaultResult("CONTINUE")
 *                 .heartbeatTimeout(2000)
 *                 .lifecycleTransition("autoscaling:EC2_INSTANCE_LAUNCHING")
 *                 .notificationMetadata(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("foo", "bar")
 *                     )))
 *                 .notificationTargetArn("arn:aws:sqs:us-east-1:444455556666:queue1*")
 *                 .roleArn("arn:aws:iam::123456789012:role/S3Access")
 *                 .build())
 *             .tags(
 *                 GroupTagArgs.builder()
 *                     .key("foo")
 *                     .value("bar")
 *                     .propagateAtLaunch(true)
 *                     .build(),
 *                 GroupTagArgs.builder()
 *                     .key("lorem")
 *                     .value("ipsum")
 *                     .propagateAtLaunch(false)
 *                     .build())
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### With Latest Version Of Launch Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new LaunchTemplate("foobar", LaunchTemplateArgs.builder()
 *             .namePrefix("foobar")
 *             .imageId("ami-1a2b3c")
 *             .instanceType("t2.micro")
 *             .build());
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .launchTemplate(GroupLaunchTemplateArgs.builder()
 *                 .id(foobar.id())
 *                 .version("$Latest")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c3.large")
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Spot Instances and Capacity Rebalance
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .capacityRebalance(true)
 *             .desiredCapacity(12)
 *             .maxSize(15)
 *             .minSize(12)
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .instancesDistribution(GroupMixedInstancesPolicyInstancesDistributionArgs.builder()
 *                     .onDemandBaseCapacity(0)
 *                     .onDemandPercentageAboveBaseCapacity(25)
 *                     .spotAllocationStrategy("capacity-optimized")
 *                     .build())
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c3.large")
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Instance level LaunchTemplateSpecification Overrides
 * When using a diverse instance set, some instance types might require a launch template with configuration values unique to that instance type such as a different AMI (Graviton2), architecture specific user data script, different EBS configuration, or different networking configuration.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var example2 = new LaunchTemplate("example2", LaunchTemplateArgs.builder()
 *             .namePrefix("example2")
 *             .imageId(data.aws_ami().example2().id())
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c4.large")
 *                             .weightedCapacity("3")
 *                             .build(),
 *                         GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                             .instanceType("c6g.large")
 *                             .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs.builder()
 *                                 .launchTemplateId(example2.id())
 *                                 .build())
 *                             .weightedCapacity("2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Mixed Instances Policy with Attribute-based Instance Type Selection
 * As an alternative to manually choosing instance types when creating a mixed instances group, you can specify a set of instance attributes that describe your compute requirements.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(1)
 *             .minSize(1)
 *             .mixedInstancesPolicy(GroupMixedInstancesPolicyArgs.builder()
 *                 .launchTemplate(GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
 *                     .launchTemplateSpecification(GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
 *                         .launchTemplateId(exampleLaunchTemplate.id())
 *                         .build())
 *                     .overrides(GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
 *                         .instanceRequirements(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs.builder()
 *                             .memoryMib(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs.builder()
 *                                 .min(1000)
 *                                 .build())
 *                             .vcpuCount(GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs.builder()
 *                                 .min(4)
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Dynamic tagging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var extraTags = config.get("extraTags").orElse(
 *             %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *             %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference));
 *         var test = new Group("test", GroupArgs.builder()
 *             .maxSize(5)
 *             .minSize(2)
 *             .launchConfiguration(aws_launch_configuration.foobar().name())
 *             .vpcZoneIdentifiers(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .tags(
 *                 GroupTagArgs.builder()
 *                     .key("explicit1")
 *                     .value("value1")
 *                     .propagateAtLaunch(true)
 *                     .build(),
 *                 GroupTagArgs.builder()
 *                     .key("explicit2")
 *                     .value("value2")
 *                     .propagateAtLaunch(true)
 *                     .build())
 *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### Automatically refresh all instances after the group is updated
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleAmi = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("amzn-ami-hvm-*-x86_64-gp2")
 *                 .build())
 *             .build());
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId(exampleAmi.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t3.nano")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(2)
 *             .minSize(1)
 *             .launchTemplate(GroupLaunchTemplateArgs.builder()
 *                 .id(exampleLaunchTemplate.id())
 *                 .version(exampleLaunchTemplate.latestVersion())
 *                 .build())
 *             .tags(GroupTagArgs.builder()
 *                 .key("Key")
 *                 .value("Value")
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .instanceRefresh(GroupInstanceRefreshArgs.builder()
 *                 .strategy("Rolling")
 *                 .preferences(GroupInstanceRefreshPreferencesArgs.builder()
 *                     .minHealthyPercentage(50)
 *                     .build())
 *                 .triggers("tag")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Scaling group with Warm Pool
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLaunchTemplate = new LaunchTemplate("exampleLaunchTemplate", LaunchTemplateArgs.builder()
 *             .namePrefix("example")
 *             .imageId(data.aws_ami().example().id())
 *             .instanceType("c5.large")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .desiredCapacity(1)
 *             .maxSize(5)
 *             .minSize(1)
 *             .warmPool(GroupWarmPoolArgs.builder()
 *                 .poolState("Hibernated")
 *                 .minSize(1)
 *                 .maxGroupPreparedCapacity(10)
 *                 .instanceReusePolicy(GroupWarmPoolInstanceReusePolicyArgs.builder()
 *                     .reuseOnScaleIn(true)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Scaling group with Traffic Sources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Group("test", GroupArgs.builder()
 *             .vpcZoneIdentifiers(aws_subnet.test().id())
 *             .maxSize(1)
 *             .minSize(1)
 *             .forceDelete(true)
 *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Waiting for Capacity
 * A newly-created ASG is initially empty and begins to scale to `min_size` (or
 * `desired_capacity`, if specified) by launching instances using the provided
 * Launch Configuration. These instances take time to launch and boot.
 * On ASG Update, changes to these values also take time to result in the target
 * number of instances providing service.
 * This provider provides two mechanisms to help consistently manage ASG scale up
 * time across dependent resources.
 * #### Waiting for ASG Capacity
 * The first is default behavior. This provider waits after ASG creation for
 * `min_size` (or `desired_capacity`, if specified) healthy instances to show up
 * in the ASG before continuing.
 * If `min_size` or `desired_capacity` are changed in a subsequent update,
 * this provider will also wait for the correct number of healthy instances before
 * continuing.
 * This provider considers an instance "healthy" when the ASG reports `HealthStatus:
 * "Healthy"` and `LifecycleState: "InService"`. See the [AWS AutoScaling
 * Docs](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
 * for more information on an ASG's lifecycle.
 * This provider will wait for healthy instances for up to
 * `wait_for_capacity_timeout`. If ASG creation is taking more than a few minutes,
 * it's worth investigating for scaling activity errors, which can be caused by
 * problems with the selected Launch Configuration.
 * Setting `wait_for_capacity_timeout` to `"0"` disables ASG Capacity waiting.
 * #### Waiting for ELB Capacity
 * The second mechanism is optional, and affects ASGs with attached ELBs specified
 * via the `load_balancers` attribute or with ALBs specified with `target_group_arns`.
 * The `min_elb_capacity` parameter causes the provider to wait for at least the
 * requested number of instances to show up `"InService"` in all attached ELBs
 * during ASG creation. It has no effect on ASG updates.
 * If `wait_for_elb_capacity` is set, the provider will wait for exactly that number
 * of Instances to be `"InService"` in all attached ELBs on both creation and
 * updates.
 * These parameters can be used to ensure that service is being provided before
 * the provider moves on. If new instances don't pass the ELB's health checks for any
 * reason, the apply will time out, and the ASG will be marked as
 * tainted (i.e., marked to be destroyed in a follow up run).
 * As with ASG Capacity, the provider will wait for up to `wait_for_capacity_timeout`
 * for the proper number of instances to be healthy.
 * #### Troubleshooting Capacity Waiting Timeouts
 * If ASG creation takes more than a few minutes, this could indicate one of a
 * number of configuration problems. See the [AWS Docs on Load Balancer
 * Troubleshooting](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-troubleshooting.html)
 * for more information.
 * ## Import
 * Using `pulumi import`, import Auto Scaling Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/group:Group web web-asg
 * ```
 * @property availabilityZones A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
 * @property capacityRebalance Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
 * @property context Reserved.
 * @property defaultCooldown Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
 * @property defaultInstanceWarmup Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
 * @property desiredCapacity Number of Amazon EC2 instances that
 * should be running in the group. (See also Waiting for
 * Capacity below.)
 * @property desiredCapacityType The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
 * @property enabledMetrics List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
 * @property forceDelete Allows deleting the Auto Scaling Group without waiting
 * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
 * even if it's in the process of scaling a resource. Normally, this provider
 * drains all the instances before deleting the group. This bypasses that
 * behavior and potentially leaves resources dangling.
 * @property forceDeleteWarmPool Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
 * @property healthCheckGracePeriod Time (in seconds) after instance comes into service before checking health.
 * @property healthCheckType "EC2" or "ELB". Controls how health checking is done.
 * @property ignoreFailedScalingActivities Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
 * @property initialLifecycleHooks One or more
 * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
 * to attach to the Auto Scaling Group **before** instances are launched. The
 * syntax is exactly the same as the separate
 * `aws.autoscaling.LifecycleHook`
 * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
 * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
 * @property instanceMaintenancePolicy If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
 * @property instanceRefresh If this block is configured, start an
 * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
 * when this Auto Scaling Group is updated. Defined below.
 * @property launchConfiguration Name of the launch configuration to use.
 * @property launchTemplate Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
 * @property loadBalancers List of elastic load balancer names to add to the autoscaling
 * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
 * @property maxInstanceLifetime Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
 * @property maxSize Maximum size of the Auto Scaling Group.
 * @property metricsGranularity Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
 * @property minElbCapacity Setting this causes Pulumi to wait for
 * this number of instances from this Auto Scaling Group to show up healthy in the
 * ELB only on creation. Updates will not wait on ELB instance number changes.
 * (See also Waiting for Capacity below.)
 * @property minSize Minimum size of the Auto Scaling Group.
 * (See also Waiting for Capacity below.)
 * @property mixedInstancesPolicy Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
 * @property name Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 * @property placementGroup Name of the placement group into which you'll launch your instances, if any.
 * @property protectFromScaleIn Whether newly launched instances
 * are automatically protected from termination by Amazon EC2 Auto Scaling when
 * scaling in. For more information about preventing instances from terminating
 * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
 * in the Amazon EC2 Auto Scaling User Guide.
 * @property serviceLinkedRoleArn ARN of the service-linked role that the ASG will use to call other AWS services
 * @property suspendedProcesses List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
 * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
 * @property tags Configuration block(s) containing resource tags. See Tag below for more details.
 * @property targetGroupArns Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
 * @property terminationPolicies List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
 * @property trafficSources Attaches one or more traffic sources to the specified Auto Scaling group.
 * @property vpcZoneIdentifiers List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
 * @property waitForCapacityTimeout Maximum
 * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
 * wait for ASG instances to be healthy before timing out. (See also Waiting
 * for Capacity below.) Setting this to "0" causes
 * the provider to skip all Capacity Waiting behavior.
 * @property waitForElbCapacity Setting this will cause Pulumi to wait
 * for exactly this number of healthy instances from this Auto Scaling Group in
 * all attached load balancers on both create and update operations. (Takes
 * precedence over `min_elb_capacity` behavior.)
 * (See also Waiting for Capacity below.)
 * @property warmPool If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
 * to the specified Auto Scaling group. Defined below
 */
public data class GroupArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val capacityRebalance: Output<Boolean>? = null,
    public val context: Output<String>? = null,
    public val defaultCooldown: Output<Int>? = null,
    public val defaultInstanceWarmup: Output<Int>? = null,
    public val desiredCapacity: Output<Int>? = null,
    public val desiredCapacityType: Output<String>? = null,
    public val enabledMetrics: Output<List<String>>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val forceDeleteWarmPool: Output<Boolean>? = null,
    public val healthCheckGracePeriod: Output<Int>? = null,
    public val healthCheckType: Output<String>? = null,
    public val ignoreFailedScalingActivities: Output<Boolean>? = null,
    public val initialLifecycleHooks: Output<List<GroupInitialLifecycleHookArgs>>? = null,
    public val instanceMaintenancePolicy: Output<GroupInstanceMaintenancePolicyArgs>? = null,
    public val instanceRefresh: Output<GroupInstanceRefreshArgs>? = null,
    public val launchConfiguration: Output<String>? = null,
    public val launchTemplate: Output<GroupLaunchTemplateArgs>? = null,
    public val loadBalancers: Output<List<String>>? = null,
    public val maxInstanceLifetime: Output<Int>? = null,
    public val maxSize: Output<Int>? = null,
    public val metricsGranularity: Output<Either<String, MetricsGranularity>>? = null,
    public val minElbCapacity: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val mixedInstancesPolicy: Output<GroupMixedInstancesPolicyArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val placementGroup: Output<String>? = null,
    public val protectFromScaleIn: Output<Boolean>? = null,
    public val serviceLinkedRoleArn: Output<String>? = null,
    public val suspendedProcesses: Output<List<String>>? = null,
    public val tags: Output<List<GroupTagArgs>>? = null,
    public val targetGroupArns: Output<List<String>>? = null,
    public val terminationPolicies: Output<List<String>>? = null,
    public val trafficSources: Output<List<GroupTrafficSourceArgs>>? = null,
    public val vpcZoneIdentifiers: Output<List<String>>? = null,
    public val waitForCapacityTimeout: Output<String>? = null,
    public val waitForElbCapacity: Output<Int>? = null,
    public val warmPool: Output<GroupWarmPoolArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.GroupArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.GroupArgs =
        com.pulumi.aws.autoscaling.GroupArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .capacityRebalance(capacityRebalance?.applyValue({ args0 -> args0 }))
            .context(context?.applyValue({ args0 -> args0 }))
            .defaultCooldown(defaultCooldown?.applyValue({ args0 -> args0 }))
            .defaultInstanceWarmup(defaultInstanceWarmup?.applyValue({ args0 -> args0 }))
            .desiredCapacity(desiredCapacity?.applyValue({ args0 -> args0 }))
            .desiredCapacityType(desiredCapacityType?.applyValue({ args0 -> args0 }))
            .enabledMetrics(enabledMetrics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .forceDeleteWarmPool(forceDeleteWarmPool?.applyValue({ args0 -> args0 }))
            .healthCheckGracePeriod(healthCheckGracePeriod?.applyValue({ args0 -> args0 }))
            .healthCheckType(healthCheckType?.applyValue({ args0 -> args0 }))
            .ignoreFailedScalingActivities(ignoreFailedScalingActivities?.applyValue({ args0 -> args0 }))
            .initialLifecycleHooks(
                initialLifecycleHooks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceMaintenancePolicy(
                instanceMaintenancePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceRefresh(instanceRefresh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .launchConfiguration(launchConfiguration?.applyValue({ args0 -> args0 }))
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadBalancers(loadBalancers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxInstanceLifetime(maxInstanceLifetime?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .metricsGranularity(
                metricsGranularity?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .minElbCapacity(minElbCapacity?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .mixedInstancesPolicy(
                mixedInstancesPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .placementGroup(placementGroup?.applyValue({ args0 -> args0 }))
            .protectFromScaleIn(protectFromScaleIn?.applyValue({ args0 -> args0 }))
            .serviceLinkedRoleArn(serviceLinkedRoleArn?.applyValue({ args0 -> args0 }))
            .suspendedProcesses(suspendedProcesses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .targetGroupArns(targetGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .terminationPolicies(terminationPolicies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trafficSources(
                trafficSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vpcZoneIdentifiers(vpcZoneIdentifiers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .waitForCapacityTimeout(waitForCapacityTimeout?.applyValue({ args0 -> args0 }))
            .waitForElbCapacity(waitForElbCapacity?.applyValue({ args0 -> args0 }))
            .warmPool(warmPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var capacityRebalance: Output<Boolean>? = null

    private var context: Output<String>? = null

    private var defaultCooldown: Output<Int>? = null

    private var defaultInstanceWarmup: Output<Int>? = null

    private var desiredCapacity: Output<Int>? = null

    private var desiredCapacityType: Output<String>? = null

    private var enabledMetrics: Output<List<String>>? = null

    private var forceDelete: Output<Boolean>? = null

    private var forceDeleteWarmPool: Output<Boolean>? = null

    private var healthCheckGracePeriod: Output<Int>? = null

    private var healthCheckType: Output<String>? = null

    private var ignoreFailedScalingActivities: Output<Boolean>? = null

    private var initialLifecycleHooks: Output<List<GroupInitialLifecycleHookArgs>>? = null

    private var instanceMaintenancePolicy: Output<GroupInstanceMaintenancePolicyArgs>? = null

    private var instanceRefresh: Output<GroupInstanceRefreshArgs>? = null

    private var launchConfiguration: Output<String>? = null

    private var launchTemplate: Output<GroupLaunchTemplateArgs>? = null

    private var loadBalancers: Output<List<String>>? = null

    private var maxInstanceLifetime: Output<Int>? = null

    private var maxSize: Output<Int>? = null

    private var metricsGranularity: Output<Either<String, MetricsGranularity>>? = null

    private var minElbCapacity: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var mixedInstancesPolicy: Output<GroupMixedInstancesPolicyArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var placementGroup: Output<String>? = null

    private var protectFromScaleIn: Output<Boolean>? = null

    private var serviceLinkedRoleArn: Output<String>? = null

    private var suspendedProcesses: Output<List<String>>? = null

    private var tags: Output<List<GroupTagArgs>>? = null

    private var targetGroupArns: Output<List<String>>? = null

    private var terminationPolicies: Output<List<String>>? = null

    private var trafficSources: Output<List<GroupTrafficSourceArgs>>? = null

    private var vpcZoneIdentifiers: Output<List<String>>? = null

    private var waitForCapacityTimeout: Output<String>? = null

    private var waitForElbCapacity: Output<Int>? = null

    private var warmPool: Output<GroupWarmPoolArgs>? = null

    /**
     * @param value A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     */
    @JvmName("bbakrjqabdqlikvm")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("vlfqqasnpbcdlfwq")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     */
    @JvmName("lbbeutadbrdrjguj")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
     */
    @JvmName("rsykhjeoennwpmlb")
    public suspend fun capacityRebalance(`value`: Output<Boolean>) {
        this.capacityRebalance = value
    }

    /**
     * @param value Reserved.
     */
    @JvmName("nealbrqwpbfxubjn")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     */
    @JvmName("tnokvmvsjtdpewkq")
    public suspend fun defaultCooldown(`value`: Output<Int>) {
        this.defaultCooldown = value
    }

    /**
     * @param value Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
     */
    @JvmName("afxwweuhelcbijsm")
    public suspend fun defaultInstanceWarmup(`value`: Output<Int>) {
        this.defaultInstanceWarmup = value
    }

    /**
     * @param value Number of Amazon EC2 instances that
     * should be running in the group. (See also Waiting for
     * Capacity below.)
     */
    @JvmName("bcqmhiaskcbuinqb")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
     */
    @JvmName("jkdvgyiyipqyjvxl")
    public suspend fun desiredCapacityType(`value`: Output<String>) {
        this.desiredCapacityType = value
    }

    /**
     * @param value List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     */
    @JvmName("kdmhitxrrandtxpk")
    public suspend fun enabledMetrics(`value`: Output<List<String>>) {
        this.enabledMetrics = value
    }

    @JvmName("nfvhtladsyttomra")
    public suspend fun enabledMetrics(vararg values: Output<String>) {
        this.enabledMetrics = Output.all(values.asList())
    }

    /**
     * @param values List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     */
    @JvmName("vhucwmsctqoybnqo")
    public suspend fun enabledMetrics(values: List<Output<String>>) {
        this.enabledMetrics = Output.all(values)
    }

    /**
     * @param value Allows deleting the Auto Scaling Group without waiting
     * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
     * even if it's in the process of scaling a resource. Normally, this provider
     * drains all the instances before deleting the group. This bypasses that
     * behavior and potentially leaves resources dangling.
     */
    @JvmName("xeihgilkfrguiklt")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
     */
    @JvmName("hlibpdjvigtpmpkt")
    public suspend fun forceDeleteWarmPool(`value`: Output<Boolean>) {
        this.forceDeleteWarmPool = value
    }

    /**
     * @param value Time (in seconds) after instance comes into service before checking health.
     */
    @JvmName("uqedmgadchtvsxye")
    public suspend fun healthCheckGracePeriod(`value`: Output<Int>) {
        this.healthCheckGracePeriod = value
    }

    /**
     * @param value "EC2" or "ELB". Controls how health checking is done.
     */
    @JvmName("nigqxbvveaylnier")
    public suspend fun healthCheckType(`value`: Output<String>) {
        this.healthCheckType = value
    }

    /**
     * @param value Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
     */
    @JvmName("lhqhrcwlwdqgbhhb")
    public suspend fun ignoreFailedScalingActivities(`value`: Output<Boolean>) {
        this.ignoreFailedScalingActivities = value
    }

    /**
     * @param value One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("enujpxocthigbktu")
    public suspend fun initialLifecycleHooks(`value`: Output<List<GroupInitialLifecycleHookArgs>>) {
        this.initialLifecycleHooks = value
    }

    @JvmName("bndxbywedpmhloxa")
    public suspend fun initialLifecycleHooks(vararg values: Output<GroupInitialLifecycleHookArgs>) {
        this.initialLifecycleHooks = Output.all(values.asList())
    }

    /**
     * @param values One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("okcdyorwtllfdpqu")
    public suspend fun initialLifecycleHooks(values: List<Output<GroupInitialLifecycleHookArgs>>) {
        this.initialLifecycleHooks = Output.all(values)
    }

    /**
     * @param value If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
     */
    @JvmName("scmmxlomvgajebxd")
    public suspend
    fun instanceMaintenancePolicy(`value`: Output<GroupInstanceMaintenancePolicyArgs>) {
        this.instanceMaintenancePolicy = value
    }

    /**
     * @param value If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     */
    @JvmName("bdbgpunkuipjqdph")
    public suspend fun instanceRefresh(`value`: Output<GroupInstanceRefreshArgs>) {
        this.instanceRefresh = value
    }

    /**
     * @param value Name of the launch configuration to use.
     */
    @JvmName("bgetnmltgplmytue")
    public suspend fun launchConfiguration(`value`: Output<String>) {
        this.launchConfiguration = value
    }

    /**
     * @param value Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     */
    @JvmName("rirgqwkfbatfasjy")
    public suspend fun launchTemplate(`value`: Output<GroupLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     */
    @JvmName("nuwsmqragukwuont")
    public suspend fun loadBalancers(`value`: Output<List<String>>) {
        this.loadBalancers = value
    }

    @JvmName("yulkuroeudyuvmie")
    public suspend fun loadBalancers(vararg values: Output<String>) {
        this.loadBalancers = Output.all(values.asList())
    }

    /**
     * @param values List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     */
    @JvmName("utdrtxdwmwphoalj")
    public suspend fun loadBalancers(values: List<Output<String>>) {
        this.loadBalancers = Output.all(values)
    }

    /**
     * @param value Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
     */
    @JvmName("tixctrumqqkpldxt")
    public suspend fun maxInstanceLifetime(`value`: Output<Int>) {
        this.maxInstanceLifetime = value
    }

    /**
     * @param value Maximum size of the Auto Scaling Group.
     */
    @JvmName("tobshlhfhsnjidkm")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     */
    @JvmName("cubbwwnglucnswkb")
    public suspend fun metricsGranularity(`value`: Output<Either<String, MetricsGranularity>>) {
        this.metricsGranularity = value
    }

    /**
     * @param value Setting this causes Pulumi to wait for
     * this number of instances from this Auto Scaling Group to show up healthy in the
     * ELB only on creation. Updates will not wait on ELB instance number changes.
     * (See also Waiting for Capacity below.)
     */
    @JvmName("vneermdlylvovoxj")
    public suspend fun minElbCapacity(`value`: Output<Int>) {
        this.minElbCapacity = value
    }

    /**
     * @param value Minimum size of the Auto Scaling Group.
     * (See also Waiting for Capacity below.)
     */
    @JvmName("qnjmeaoicckyowuo")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     */
    @JvmName("cjqmgkwwmelvobqo")
    public suspend fun mixedInstancesPolicy(`value`: Output<GroupMixedInstancesPolicyArgs>) {
        this.mixedInstancesPolicy = value
    }

    /**
     * @param value Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     */
    @JvmName("jksyabsljkcidaaj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("tptmbxiqikjindbo")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Name of the placement group into which you'll launch your instances, if any.
     */
    @JvmName("wdlyoiykfyncjtmy")
    public suspend fun placementGroup(`value`: Output<String>) {
        this.placementGroup = value
    }

    /**
     * @param value Whether newly launched instances
     * are automatically protected from termination by Amazon EC2 Auto Scaling when
     * scaling in. For more information about preventing instances from terminating
     * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
     * in the Amazon EC2 Auto Scaling User Guide.
     */
    @JvmName("okheuwcreuyromxw")
    public suspend fun protectFromScaleIn(`value`: Output<Boolean>) {
        this.protectFromScaleIn = value
    }

    /**
     * @param value ARN of the service-linked role that the ASG will use to call other AWS services
     */
    @JvmName("rtvstaiwllqbhqkq")
    public suspend fun serviceLinkedRoleArn(`value`: Output<String>) {
        this.serviceLinkedRoleArn = value
    }

    /**
     * @param value List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     */
    @JvmName("nxcdufqaiarmykeq")
    public suspend fun suspendedProcesses(`value`: Output<List<String>>) {
        this.suspendedProcesses = value
    }

    @JvmName("yavdymkohfhyyppm")
    public suspend fun suspendedProcesses(vararg values: Output<String>) {
        this.suspendedProcesses = Output.all(values.asList())
    }

    /**
     * @param values List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     */
    @JvmName("wdgftbydulopthpp")
    public suspend fun suspendedProcesses(values: List<Output<String>>) {
        this.suspendedProcesses = Output.all(values)
    }

    /**
     * @param value Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("qloeawotswrqymki")
    public suspend fun tags(`value`: Output<List<GroupTagArgs>>) {
        this.tags = value
    }

    @JvmName("ecfpxwqodkydlosk")
    public suspend fun tags(vararg values: Output<GroupTagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("nrhpxpmrsvtkspuw")
    public suspend fun tags(values: List<Output<GroupTagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     */
    @JvmName("ecdvyfpyddkpxena")
    public suspend fun targetGroupArns(`value`: Output<List<String>>) {
        this.targetGroupArns = value
    }

    @JvmName("rhhcpspsshdoscdp")
    public suspend fun targetGroupArns(vararg values: Output<String>) {
        this.targetGroupArns = Output.all(values.asList())
    }

    /**
     * @param values Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     */
    @JvmName("snuqmvkslbeodfng")
    public suspend fun targetGroupArns(values: List<Output<String>>) {
        this.targetGroupArns = Output.all(values)
    }

    /**
     * @param value List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     */
    @JvmName("jvsgsouddagjvdkg")
    public suspend fun terminationPolicies(`value`: Output<List<String>>) {
        this.terminationPolicies = value
    }

    @JvmName("wlxkrlvjlilncpav")
    public suspend fun terminationPolicies(vararg values: Output<String>) {
        this.terminationPolicies = Output.all(values.asList())
    }

    /**
     * @param values List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     */
    @JvmName("pkluallocdicnjai")
    public suspend fun terminationPolicies(values: List<Output<String>>) {
        this.terminationPolicies = Output.all(values)
    }

    /**
     * @param value Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("qlopfejihaetktox")
    public suspend fun trafficSources(`value`: Output<List<GroupTrafficSourceArgs>>) {
        this.trafficSources = value
    }

    @JvmName("yadobeovpxjhwcor")
    public suspend fun trafficSources(vararg values: Output<GroupTrafficSourceArgs>) {
        this.trafficSources = Output.all(values.asList())
    }

    /**
     * @param values Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("xgvtdrlvyolvdrry")
    public suspend fun trafficSources(values: List<Output<GroupTrafficSourceArgs>>) {
        this.trafficSources = Output.all(values)
    }

    /**
     * @param value List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     */
    @JvmName("ckkbnorwyvbvebtc")
    public suspend fun vpcZoneIdentifiers(`value`: Output<List<String>>) {
        this.vpcZoneIdentifiers = value
    }

    @JvmName("exfrljrfacjnftrf")
    public suspend fun vpcZoneIdentifiers(vararg values: Output<String>) {
        this.vpcZoneIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     */
    @JvmName("yqeutvoogrfkebuv")
    public suspend fun vpcZoneIdentifiers(values: List<Output<String>>) {
        this.vpcZoneIdentifiers = Output.all(values)
    }

    /**
     * @param value Maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
     * wait for ASG instances to be healthy before timing out. (See also Waiting
     * for Capacity below.) Setting this to "0" causes
     * the provider to skip all Capacity Waiting behavior.
     */
    @JvmName("aqoqejgglldfbpst")
    public suspend fun waitForCapacityTimeout(`value`: Output<String>) {
        this.waitForCapacityTimeout = value
    }

    /**
     * @param value Setting this will cause Pulumi to wait
     * for exactly this number of healthy instances from this Auto Scaling Group in
     * all attached load balancers on both create and update operations. (Takes
     * precedence over `min_elb_capacity` behavior.)
     * (See also Waiting for Capacity below.)
     */
    @JvmName("qvpfjvolovhortgd")
    public suspend fun waitForElbCapacity(`value`: Output<Int>) {
        this.waitForElbCapacity = value
    }

    /**
     * @param value If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     */
    @JvmName("lywwfcfepapuatvh")
    public suspend fun warmPool(`value`: Output<GroupWarmPoolArgs>) {
        this.warmPool = value
    }

    /**
     * @param value A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     */
    @JvmName("yjigxciasuirbjoa")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     */
    @JvmName("kxfetjpuobcunxnu")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
     */
    @JvmName("qlchtonyprxjlefb")
    public suspend fun capacityRebalance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityRebalance = mapped
    }

    /**
     * @param value Reserved.
     */
    @JvmName("mcxxijtfldqxtdsc")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     */
    @JvmName("wapjgodcovehymfi")
    public suspend fun defaultCooldown(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCooldown = mapped
    }

    /**
     * @param value Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
     */
    @JvmName("javobmtltlisompx")
    public suspend fun defaultInstanceWarmup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultInstanceWarmup = mapped
    }

    /**
     * @param value Number of Amazon EC2 instances that
     * should be running in the group. (See also Waiting for
     * Capacity below.)
     */
    @JvmName("jmwxgnvuginjfrlp")
    public suspend fun desiredCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    /**
     * @param value The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
     */
    @JvmName("ttlgutffpsrnvils")
    public suspend fun desiredCapacityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacityType = mapped
    }

    /**
     * @param value List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     */
    @JvmName("rhevtypewewatdmq")
    public suspend fun enabledMetrics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledMetrics = mapped
    }

    /**
     * @param values List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     */
    @JvmName("biyocterdxsjtgnv")
    public suspend fun enabledMetrics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledMetrics = mapped
    }

    /**
     * @param value Allows deleting the Auto Scaling Group without waiting
     * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
     * even if it's in the process of scaling a resource. Normally, this provider
     * drains all the instances before deleting the group. This bypasses that
     * behavior and potentially leaves resources dangling.
     */
    @JvmName("odyowcljuaguujns")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
     */
    @JvmName("egqngpkbcraoxbwe")
    public suspend fun forceDeleteWarmPool(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDeleteWarmPool = mapped
    }

    /**
     * @param value Time (in seconds) after instance comes into service before checking health.
     */
    @JvmName("nescnefovjcptfta")
    public suspend fun healthCheckGracePeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckGracePeriod = mapped
    }

    /**
     * @param value "EC2" or "ELB". Controls how health checking is done.
     */
    @JvmName("gywpyudqngcdyjiv")
    public suspend fun healthCheckType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckType = mapped
    }

    /**
     * @param value Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
     */
    @JvmName("aempwnhnlaedmlce")
    public suspend fun ignoreFailedScalingActivities(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreFailedScalingActivities = mapped
    }

    /**
     * @param value One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("xkcrtktosjbsvbih")
    public suspend fun initialLifecycleHooks(`value`: List<GroupInitialLifecycleHookArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialLifecycleHooks = mapped
    }

    /**
     * @param argument One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("cttoytskxlgavjgi")
    public suspend
    fun initialLifecycleHooks(argument: List<suspend GroupInitialLifecycleHookArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupInitialLifecycleHookArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initialLifecycleHooks = mapped
    }

    /**
     * @param argument One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("ncufscepwuajoios")
    public suspend fun initialLifecycleHooks(
        vararg
        argument: suspend GroupInitialLifecycleHookArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupInitialLifecycleHookArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initialLifecycleHooks = mapped
    }

    /**
     * @param argument One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("etxvvdauvgoqqpgr")
    public suspend
    fun initialLifecycleHooks(argument: suspend GroupInitialLifecycleHookArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GroupInitialLifecycleHookArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initialLifecycleHooks = mapped
    }

    /**
     * @param values One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     */
    @JvmName("bpujxmolnufjnaba")
    public suspend fun initialLifecycleHooks(vararg values: GroupInitialLifecycleHookArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialLifecycleHooks = mapped
    }

    /**
     * @param value If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
     */
    @JvmName("ksakcoacsyyoalxg")
    public suspend fun instanceMaintenancePolicy(`value`: GroupInstanceMaintenancePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMaintenancePolicy = mapped
    }

    /**
     * @param argument If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
     */
    @JvmName("gkomilybancbchnc")
    public suspend
    fun instanceMaintenancePolicy(argument: suspend GroupInstanceMaintenancePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = GroupInstanceMaintenancePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.instanceMaintenancePolicy = mapped
    }

    /**
     * @param value If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     */
    @JvmName("gosawgkpoigikdfm")
    public suspend fun instanceRefresh(`value`: GroupInstanceRefreshArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRefresh = mapped
    }

    /**
     * @param argument If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     */
    @JvmName("fhreaatyfvwvqaxq")
    public suspend fun instanceRefresh(argument: suspend GroupInstanceRefreshArgsBuilder.() -> Unit) {
        val toBeMapped = GroupInstanceRefreshArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.instanceRefresh = mapped
    }

    /**
     * @param value Name of the launch configuration to use.
     */
    @JvmName("xpcegvvgoqdlineu")
    public suspend fun launchConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchConfiguration = mapped
    }

    /**
     * @param value Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     */
    @JvmName("punnqwupwsbfcxfj")
    public suspend fun launchTemplate(`value`: GroupLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     */
    @JvmName("xltrgnahthnfnujs")
    public suspend fun launchTemplate(argument: suspend GroupLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = GroupLaunchTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     */
    @JvmName("libvyyamkjbkhdnt")
    public suspend fun loadBalancers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param values List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     */
    @JvmName("kiuphpqpxrdprtwu")
    public suspend fun loadBalancers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param value Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
     */
    @JvmName("ndxnbryftthpmovc")
    public suspend fun maxInstanceLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInstanceLifetime = mapped
    }

    /**
     * @param value Maximum size of the Auto Scaling Group.
     */
    @JvmName("spwyuhvbeocpmchy")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     */
    @JvmName("qlqxnhxqgnjpdwbj")
    public suspend fun metricsGranularity(`value`: Either<String, MetricsGranularity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsGranularity = mapped
    }

    /**
     * @param value Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     */
    @JvmName("qjfbworrfjotswya")
    public fun metricsGranularity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MetricsGranularity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricsGranularity = mapped
    }

    /**
     * @param value Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     */
    @JvmName("oonymjnoxcfbnntm")
    public fun metricsGranularity(`value`: MetricsGranularity) {
        val toBeMapped = Either.ofRight<String, MetricsGranularity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricsGranularity = mapped
    }

    /**
     * @param value Setting this causes Pulumi to wait for
     * this number of instances from this Auto Scaling Group to show up healthy in the
     * ELB only on creation. Updates will not wait on ELB instance number changes.
     * (See also Waiting for Capacity below.)
     */
    @JvmName("ufjivgwckyobtrka")
    public suspend fun minElbCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minElbCapacity = mapped
    }

    /**
     * @param value Minimum size of the Auto Scaling Group.
     * (See also Waiting for Capacity below.)
     */
    @JvmName("ltgwhsxdqgvgliup")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     */
    @JvmName("yjlqwnjiffjitbbi")
    public suspend fun mixedInstancesPolicy(`value`: GroupMixedInstancesPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mixedInstancesPolicy = mapped
    }

    /**
     * @param argument Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     */
    @JvmName("slcgptrgaueifiri")
    public suspend
    fun mixedInstancesPolicy(argument: suspend GroupMixedInstancesPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMixedInstancesPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mixedInstancesPolicy = mapped
    }

    /**
     * @param value Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     */
    @JvmName("bonakopmqljqydri")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("koatdietavxhlbhc")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Name of the placement group into which you'll launch your instances, if any.
     */
    @JvmName("amfbpfxvekyjbdbp")
    public suspend fun placementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroup = mapped
    }

    /**
     * @param value Whether newly launched instances
     * are automatically protected from termination by Amazon EC2 Auto Scaling when
     * scaling in. For more information about preventing instances from terminating
     * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
     * in the Amazon EC2 Auto Scaling User Guide.
     */
    @JvmName("sghicifoowacvpbt")
    public suspend fun protectFromScaleIn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectFromScaleIn = mapped
    }

    /**
     * @param value ARN of the service-linked role that the ASG will use to call other AWS services
     */
    @JvmName("gdgvxiksjwvlblxi")
    public suspend fun serviceLinkedRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLinkedRoleArn = mapped
    }

    /**
     * @param value List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     */
    @JvmName("ivlggbymgqjgsvcq")
    public suspend fun suspendedProcesses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suspendedProcesses = mapped
    }

    /**
     * @param values List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     */
    @JvmName("avinwlihoflshnhb")
    public suspend fun suspendedProcesses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suspendedProcesses = mapped
    }

    /**
     * @param value Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("ngejonhfxdedhiuq")
    public suspend fun tags(`value`: List<GroupTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("gcndekyxnnnjifrq")
    public suspend fun tags(argument: List<suspend GroupTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GroupTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("gebqthfvucccjlai")
    public suspend fun tags(vararg argument: suspend GroupTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GroupTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("hkqlhermnlsflqox")
    public suspend fun tags(argument: suspend GroupTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values Configuration block(s) containing resource tags. See Tag below for more details.
     */
    @JvmName("omgwxeranpiwwdxb")
    public suspend fun tags(vararg values: GroupTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     */
    @JvmName("gndqultixvbhjfqm")
    public suspend fun targetGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArns = mapped
    }

    /**
     * @param values Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     */
    @JvmName("cejgiexkmfpydhog")
    public suspend fun targetGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroupArns = mapped
    }

    /**
     * @param value List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     */
    @JvmName("kiuhdssghsaqqdoy")
    public suspend fun terminationPolicies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationPolicies = mapped
    }

    /**
     * @param values List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     */
    @JvmName("xudaqmlekhbbfuxq")
    public suspend fun terminationPolicies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.terminationPolicies = mapped
    }

    /**
     * @param value Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("wcuodxmwwgebmvxh")
    public suspend fun trafficSources(`value`: List<GroupTrafficSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSources = mapped
    }

    /**
     * @param argument Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("qlquhegkdppkscre")
    public suspend
    fun trafficSources(argument: List<suspend GroupTrafficSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupTrafficSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSources = mapped
    }

    /**
     * @param argument Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("ormmudrqfyoahgdl")
    public suspend fun trafficSources(
        vararg
        argument: suspend GroupTrafficSourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupTrafficSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSources = mapped
    }

    /**
     * @param argument Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("wrexsxafhnwblcdu")
    public suspend fun trafficSources(argument: suspend GroupTrafficSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupTrafficSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trafficSources = mapped
    }

    /**
     * @param values Attaches one or more traffic sources to the specified Auto Scaling group.
     */
    @JvmName("ewgqesnuxuehplhh")
    public suspend fun trafficSources(vararg values: GroupTrafficSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficSources = mapped
    }

    /**
     * @param value List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     */
    @JvmName("pilqdbjhuwntddnn")
    public suspend fun vpcZoneIdentifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcZoneIdentifiers = mapped
    }

    /**
     * @param values List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     */
    @JvmName("isxhhwsnwykrnphq")
    public suspend fun vpcZoneIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcZoneIdentifiers = mapped
    }

    /**
     * @param value Maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
     * wait for ASG instances to be healthy before timing out. (See also Waiting
     * for Capacity below.) Setting this to "0" causes
     * the provider to skip all Capacity Waiting behavior.
     */
    @JvmName("btdsnfavykhxxquv")
    public suspend fun waitForCapacityTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForCapacityTimeout = mapped
    }

    /**
     * @param value Setting this will cause Pulumi to wait
     * for exactly this number of healthy instances from this Auto Scaling Group in
     * all attached load balancers on both create and update operations. (Takes
     * precedence over `min_elb_capacity` behavior.)
     * (See also Waiting for Capacity below.)
     */
    @JvmName("kdpisnombirgkmly")
    public suspend fun waitForElbCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForElbCapacity = mapped
    }

    /**
     * @param value If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     */
    @JvmName("dctindylyrvtxtsg")
    public suspend fun warmPool(`value`: GroupWarmPoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmPool = mapped
    }

    /**
     * @param argument If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     */
    @JvmName("kcbinvilpldloxnn")
    public suspend fun warmPool(argument: suspend GroupWarmPoolArgsBuilder.() -> Unit) {
        val toBeMapped = GroupWarmPoolArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.warmPool = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        availabilityZones = availabilityZones,
        capacityRebalance = capacityRebalance,
        context = context,
        defaultCooldown = defaultCooldown,
        defaultInstanceWarmup = defaultInstanceWarmup,
        desiredCapacity = desiredCapacity,
        desiredCapacityType = desiredCapacityType,
        enabledMetrics = enabledMetrics,
        forceDelete = forceDelete,
        forceDeleteWarmPool = forceDeleteWarmPool,
        healthCheckGracePeriod = healthCheckGracePeriod,
        healthCheckType = healthCheckType,
        ignoreFailedScalingActivities = ignoreFailedScalingActivities,
        initialLifecycleHooks = initialLifecycleHooks,
        instanceMaintenancePolicy = instanceMaintenancePolicy,
        instanceRefresh = instanceRefresh,
        launchConfiguration = launchConfiguration,
        launchTemplate = launchTemplate,
        loadBalancers = loadBalancers,
        maxInstanceLifetime = maxInstanceLifetime,
        maxSize = maxSize,
        metricsGranularity = metricsGranularity,
        minElbCapacity = minElbCapacity,
        minSize = minSize,
        mixedInstancesPolicy = mixedInstancesPolicy,
        name = name,
        namePrefix = namePrefix,
        placementGroup = placementGroup,
        protectFromScaleIn = protectFromScaleIn,
        serviceLinkedRoleArn = serviceLinkedRoleArn,
        suspendedProcesses = suspendedProcesses,
        tags = tags,
        targetGroupArns = targetGroupArns,
        terminationPolicies = terminationPolicies,
        trafficSources = trafficSources,
        vpcZoneIdentifiers = vpcZoneIdentifiers,
        waitForCapacityTimeout = waitForCapacityTimeout,
        waitForElbCapacity = waitForElbCapacity,
        warmPool = warmPool,
    )
}
