@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LifecycleHook].
 */
@PulumiTagMarker
public class LifecycleHookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LifecycleHookArgs = LifecycleHookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LifecycleHookArgsBuilder.() -> Unit) {
        val builder = LifecycleHookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LifecycleHook {
        val builtJavaResource = com.pulumi.aws.autoscaling.LifecycleHook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LifecycleHook(builtJavaResource)
    }
}

/**
 * Provides an AutoScaling Lifecycle Hook resource.
 * > **NOTE:** This provider has two types of ways you can add lifecycle hooks - via
 * the `initial_lifecycle_hook` attribute from the
 * `aws.autoscaling.Group`
 * resource, or via this one. Hooks added via this resource will not be added
 * until the autoscaling group has been created, and depending on your
 * capacity
 * settings, after the initial instances have been launched, creating unintended
 * behavior. If you need hooks to run on all instances, add them with
 * `initial_lifecycle_hook` in
 * `aws.autoscaling.Group`,
 * but take care to not duplicate those hooks with this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.autoscaling.LifecycleHook;
 * import com.pulumi.aws.autoscaling.LifecycleHookArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobarGroup = new Group("foobarGroup", GroupArgs.builder()
 *             .availabilityZones("us-west-2a")
 *             .healthCheckType("EC2")
 *             .terminationPolicies("OldestInstance")
 *             .tags(GroupTagArgs.builder()
 *                 .key("Foo")
 *                 .value("foo-bar")
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .build());
 *         var foobarLifecycleHook = new LifecycleHook("foobarLifecycleHook", LifecycleHookArgs.builder()
 *             .autoscalingGroupName(foobarGroup.name())
 *             .defaultResult("CONTINUE")
 *             .heartbeatTimeout(2000)
 *             .lifecycleTransition("autoscaling:EC2_INSTANCE_LAUNCHING")
 *             .notificationMetadata(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("foo", "bar")
 *                 )))
 *             .notificationTargetArn("arn:aws:sqs:us-east-1:444455556666:queue1*")
 *             .roleArn("arn:aws:iam::123456789012:role/S3Access")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AutoScaling Lifecycle Hooks using the role autoscaling_group_name and name separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/lifecycleHook:LifecycleHook test-lifecycle-hook asg-name/lifecycle-hook-name
 * ```
 *
 */
public class LifecycleHook internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.LifecycleHook,
) : KotlinCustomResource(javaResource, LifecycleHookMapper) {
    /**
     * Name of the Auto Scaling group to which you want to assign the lifecycle hook
     */
    public val autoscalingGroupName: Output<String>
        get() = javaResource.autoscalingGroupName().applyValue({ args0 -> args0 })

    /**
     * Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The value for this parameter can be either CONTINUE or ABANDON. The default value for this parameter is ABANDON.
     */
    public val defaultResult: Output<String>
        get() = javaResource.defaultResult().applyValue({ args0 -> args0 })

    /**
     * Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the DefaultResult parameter
     */
    public val heartbeatTimeout: Output<Int>?
        get() = javaResource.heartbeatTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see [describe-lifecycle-hook-types](https://docs.aws.amazon.com/cli/latest/reference/autoscaling/describe-lifecycle-hook-types.html#examples)
     */
    public val lifecycleTransition: Output<String>
        get() = javaResource.lifecycleTransition().applyValue({ args0 -> args0 })

    /**
     * Name of the lifecycle hook.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Contains additional information that you want to include any time Auto Scaling sends a message to the notification target.
     */
    public val notificationMetadata: Output<String>?
        get() = javaResource.notificationMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition state for the lifecycle hook. This ARN target can be either an SQS queue or an SNS topic.
     */
    public val notificationTargetArn: Output<String>?
        get() = javaResource.notificationTargetArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object LifecycleHookMapper : ResourceMapper<LifecycleHook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.LifecycleHook::class == javaResource::class

    override fun map(javaResource: Resource): LifecycleHook = LifecycleHook(
        javaResource as
            com.pulumi.aws.autoscaling.LifecycleHook,
    )
}

/**
 * @see [LifecycleHook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LifecycleHook].
 */
public suspend fun lifecycleHook(
    name: String,
    block: suspend LifecycleHookResourceBuilder.() -> Unit,
): LifecycleHook {
    val builder = LifecycleHookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LifecycleHook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lifecycleHook(name: String): LifecycleHook {
    val builder = LifecycleHookResourceBuilder()
    builder.name(name)
    return builder.build()
}
