@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.LifecycleHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AutoScaling Lifecycle Hook resource.
 * > **NOTE:** This provider has two types of ways you can add lifecycle hooks - via
 * the `initial_lifecycle_hook` attribute from the
 * `aws.autoscaling.Group`
 * resource, or via this one. Hooks added via this resource will not be added
 * until the autoscaling group has been created, and depending on your
 * capacity
 * settings, after the initial instances have been launched, creating unintended
 * behavior. If you need hooks to run on all instances, add them with
 * `initial_lifecycle_hook` in
 * `aws.autoscaling.Group`,
 * but take care to not duplicate those hooks with this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.autoscaling.LifecycleHook;
 * import com.pulumi.aws.autoscaling.LifecycleHookArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobarGroup = new Group("foobarGroup", GroupArgs.builder()
 *             .availabilityZones("us-west-2a")
 *             .healthCheckType("EC2")
 *             .terminationPolicies("OldestInstance")
 *             .tags(GroupTagArgs.builder()
 *                 .key("Foo")
 *                 .value("foo-bar")
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .build());
 *         var foobarLifecycleHook = new LifecycleHook("foobarLifecycleHook", LifecycleHookArgs.builder()
 *             .autoscalingGroupName(foobarGroup.name())
 *             .defaultResult("CONTINUE")
 *             .heartbeatTimeout(2000)
 *             .lifecycleTransition("autoscaling:EC2_INSTANCE_LAUNCHING")
 *             .notificationMetadata(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("foo", "bar")
 *                 )))
 *             .notificationTargetArn("arn:aws:sqs:us-east-1:444455556666:queue1*")
 *             .roleArn("arn:aws:iam::123456789012:role/S3Access")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AutoScaling Lifecycle Hooks using the role autoscaling_group_name and name separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/lifecycleHook:LifecycleHook test-lifecycle-hook asg-name/lifecycle-hook-name
 * ```
 * @property autoscalingGroupName Name of the Auto Scaling group to which you want to assign the lifecycle hook
 * @property defaultResult Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The value for this parameter can be either CONTINUE or ABANDON. The default value for this parameter is ABANDON.
 * @property heartbeatTimeout Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the DefaultResult parameter
 * @property lifecycleTransition Instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see [describe-lifecycle-hook-types](https://docs.aws.amazon.com/cli/latest/reference/autoscaling/describe-lifecycle-hook-types.html#examples)
 * @property name Name of the lifecycle hook.
 * @property notificationMetadata Contains additional information that you want to include any time Auto Scaling sends a message to the notification target.
 * @property notificationTargetArn ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition state for the lifecycle hook. This ARN target can be either an SQS queue or an SNS topic.
 * @property roleArn ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
 */
public data class LifecycleHookArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val defaultResult: Output<String>? = null,
    public val heartbeatTimeout: Output<Int>? = null,
    public val lifecycleTransition: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notificationMetadata: Output<String>? = null,
    public val notificationTargetArn: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.LifecycleHookArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.LifecycleHookArgs =
        com.pulumi.aws.autoscaling.LifecycleHookArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .defaultResult(defaultResult?.applyValue({ args0 -> args0 }))
            .heartbeatTimeout(heartbeatTimeout?.applyValue({ args0 -> args0 }))
            .lifecycleTransition(lifecycleTransition?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationMetadata(notificationMetadata?.applyValue({ args0 -> args0 }))
            .notificationTargetArn(notificationTargetArn?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecycleHookArgs].
 */
@PulumiTagMarker
public class LifecycleHookArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var defaultResult: Output<String>? = null

    private var heartbeatTimeout: Output<Int>? = null

    private var lifecycleTransition: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationMetadata: Output<String>? = null

    private var notificationTargetArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Name of the Auto Scaling group to which you want to assign the lifecycle hook
     */
    @JvmName("qgfwuprrxksetipb")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The value for this parameter can be either CONTINUE or ABANDON. The default value for this parameter is ABANDON.
     */
    @JvmName("xlpfgkpgnprfxibh")
    public suspend fun defaultResult(`value`: Output<String>) {
        this.defaultResult = value
    }

    /**
     * @param value Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the DefaultResult parameter
     */
    @JvmName("vhwfadrslgdbapnv")
    public suspend fun heartbeatTimeout(`value`: Output<Int>) {
        this.heartbeatTimeout = value
    }

    /**
     * @param value Instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see [describe-lifecycle-hook-types](https://docs.aws.amazon.com/cli/latest/reference/autoscaling/describe-lifecycle-hook-types.html#examples)
     */
    @JvmName("kqueftdkagmfifhu")
    public suspend fun lifecycleTransition(`value`: Output<String>) {
        this.lifecycleTransition = value
    }

    /**
     * @param value Name of the lifecycle hook.
     */
    @JvmName("efkndcuxhxudxlcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Contains additional information that you want to include any time Auto Scaling sends a message to the notification target.
     */
    @JvmName("rrxcfwfjlepnnwev")
    public suspend fun notificationMetadata(`value`: Output<String>) {
        this.notificationMetadata = value
    }

    /**
     * @param value ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition state for the lifecycle hook. This ARN target can be either an SQS queue or an SNS topic.
     */
    @JvmName("bbmyjaxqhqdftptg")
    public suspend fun notificationTargetArn(`value`: Output<String>) {
        this.notificationTargetArn = value
    }

    /**
     * @param value ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     */
    @JvmName("qbkosekxcskitwuh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Name of the Auto Scaling group to which you want to assign the lifecycle hook
     */
    @JvmName("mlxaoynlfgrciejs")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The value for this parameter can be either CONTINUE or ABANDON. The default value for this parameter is ABANDON.
     */
    @JvmName("gftxsaamshdnknyb")
    public suspend fun defaultResult(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResult = mapped
    }

    /**
     * @param value Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the DefaultResult parameter
     */
    @JvmName("cttnmbcohdxtpnyt")
    public suspend fun heartbeatTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.heartbeatTimeout = mapped
    }

    /**
     * @param value Instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see [describe-lifecycle-hook-types](https://docs.aws.amazon.com/cli/latest/reference/autoscaling/describe-lifecycle-hook-types.html#examples)
     */
    @JvmName("cjmotyckllbytidn")
    public suspend fun lifecycleTransition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleTransition = mapped
    }

    /**
     * @param value Name of the lifecycle hook.
     */
    @JvmName("pequydnatboqoyga")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Contains additional information that you want to include any time Auto Scaling sends a message to the notification target.
     */
    @JvmName("nocnhrubwiqewffg")
    public suspend fun notificationMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationMetadata = mapped
    }

    /**
     * @param value ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition state for the lifecycle hook. This ARN target can be either an SQS queue or an SNS topic.
     */
    @JvmName("cvffwqvddadujfrb")
    public suspend fun notificationTargetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTargetArn = mapped
    }

    /**
     * @param value ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     */
    @JvmName("vwnvmjgjvnysxahg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): LifecycleHookArgs = LifecycleHookArgs(
        autoscalingGroupName = autoscalingGroupName,
        defaultResult = defaultResult,
        heartbeatTimeout = heartbeatTimeout,
        lifecycleTransition = lifecycleTransition,
        name = name,
        notificationMetadata = notificationMetadata,
        notificationTargetArn = notificationTargetArn,
        roleArn = roleArn,
    )
}
